/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.LoggingOptions;
import com.microsoft.rest.v2.http.HttpPipelineLogLevel;
import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import io.reactivex.Single;
import java.util.Locale;

public final class LoggingFactory
implements RequestPolicyFactory {
    private final LoggingOptions loggingOptions;

    public LoggingFactory(LoggingOptions loggingOptions) {
        this.loggingOptions = loggingOptions == null ? LoggingOptions.DEFAULT : loggingOptions;
    }

    public RequestPolicy create(RequestPolicy next, RequestPolicyOptions options) {
        return new LoggingPolicy(this, next, options);
    }

    private final class LoggingPolicy
    implements RequestPolicy {
        private final LoggingFactory factory;
        private final RequestPolicy nextPolicy;
        private final RequestPolicyOptions options;
        private int tryCount;
        private long operationStartTime;
        private long requestStartTime;

        private LoggingPolicy(LoggingFactory factory, RequestPolicy nextPolicy, RequestPolicyOptions options) {
            this.factory = factory;
            this.nextPolicy = nextPolicy;
            this.options = options;
        }

        public Single<HttpResponse> sendAsync(HttpRequest request) {
            ++this.tryCount;
            this.requestStartTime = System.currentTimeMillis();
            if (this.tryCount == 1) {
                this.operationStartTime = this.requestStartTime;
            }
            if (this.options.shouldLog(HttpPipelineLogLevel.INFO)) {
                this.options.log(HttpPipelineLogLevel.INFO, String.format("'%s'==> OUTGOING REQUEST (Try number='%d')%n", request.url(), this.tryCount), new Object[0]);
            }
            return this.nextPolicy.sendAsync(request).doOnError(throwable -> {
                if (this.options.shouldLog(HttpPipelineLogLevel.ERROR)) {
                    this.options.log(HttpPipelineLogLevel.ERROR, String.format("Unexpected failure attempting to make request.%nError message:'%s'%n", throwable.getMessage()), new Object[0]);
                }
            }).doOnSuccess(response -> {
                long requestEndTime = System.currentTimeMillis();
                long requestCompletionTime = requestEndTime - this.requestStartTime;
                long operationDuration = requestEndTime - this.operationStartTime;
                HttpPipelineLogLevel currentLevel = HttpPipelineLogLevel.INFO;
                if (!this.options.shouldLog(HttpPipelineLogLevel.ERROR)) {
                    return;
                }
                String logMessage = "";
                if (this.options.shouldLog(HttpPipelineLogLevel.INFO)) {
                    logMessage = "Successfully Received Response" + System.lineSeparator();
                }
                if (requestCompletionTime >= this.factory.loggingOptions.minDurationToLogSlowRequestsInMs() && this.options.shouldLog(HttpPipelineLogLevel.WARNING)) {
                    currentLevel = HttpPipelineLogLevel.WARNING;
                    logMessage = String.format(Locale.ROOT, "SLOW OPERATION. Duration > %d ms.%n", this.factory.loggingOptions.minDurationToLogSlowRequestsInMs());
                }
                if (response.statusCode() >= 400 && response.statusCode() <= 499 && response.statusCode() != 404 && response.statusCode() != 409 && response.statusCode() != 412 && response.statusCode() != 416 || response.statusCode() >= 500 && response.statusCode() <= 509) {
                    String errorString = String.format(Locale.ROOT, "REQUEST ERROR%nHTTP request failed with status code:'%d'%n", response.statusCode());
                    logMessage = currentLevel == HttpPipelineLogLevel.WARNING ? String.valueOf(logMessage) + errorString : errorString;
                    currentLevel = HttpPipelineLogLevel.ERROR;
                }
                if (this.options.shouldLog(currentLevel)) {
                    String messageInfo = String.format(Locale.ROOT, "Request try:'%d', request duration:'%d' ms, operation duration:'%d' ms%n", this.tryCount, requestCompletionTime, operationDuration);
                    this.options.log(currentLevel, String.valueOf(logMessage) + messageInfo, new Object[0]);
                }
            });
        }
    }
}

