/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.ContainerURL;
import com.microsoft.azure.storage.blob.ListContainersOptions;
import com.microsoft.azure.storage.blob.StorageURL;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.azure.storage.blob.models.ServiceGetAccountInfoResponse;
import com.microsoft.azure.storage.blob.models.ServiceGetPropertiesResponse;
import com.microsoft.azure.storage.blob.models.ServiceGetStatisticsResponse;
import com.microsoft.azure.storage.blob.models.ServiceListContainersSegmentResponse;
import com.microsoft.azure.storage.blob.models.ServiceSetPropertiesResponse;
import com.microsoft.azure.storage.blob.models.StorageServiceProperties;
import com.microsoft.rest.v2.Context;
import com.microsoft.rest.v2.http.HttpPipeline;
import io.reactivex.Single;
import java.net.MalformedURLException;
import java.net.URL;

public final class ServiceURL
extends StorageURL {
    public ServiceURL(URL url, HttpPipeline pipeline) {
        super(url, pipeline);
    }

    public ContainerURL createContainerURL(String containerName) {
        try {
            return new ContainerURL(StorageURL.appendToURLPath(new URL(this.storageClient.url()), containerName), this.storageClient.httpPipeline());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public ServiceURL withPipeline(HttpPipeline pipeline) {
        try {
            return new ServiceURL(new URL(this.storageClient.url()), pipeline);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Single<ServiceListContainersSegmentResponse> listContainersSegment(String marker, ListContainersOptions options, Context context) {
        options = options == null ? ListContainersOptions.DEFAULT : options;
        context = context == null ? Context.NONE : context;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedServices().listContainersSegmentWithRestResponseAsync(context, options.prefix(), marker, options.maxResults(), options.details().toIncludeType(), null, null));
    }

    public Single<ServiceGetPropertiesResponse> getProperties(Context context) {
        context = context == null ? Context.NONE : context;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedServices().getPropertiesWithRestResponseAsync(context, null, null));
    }

    public Single<ServiceSetPropertiesResponse> setProperties(StorageServiceProperties properties, Context context) {
        context = context == null ? Context.NONE : context;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedServices().setPropertiesWithRestResponseAsync(context, properties, null, null));
    }

    public Single<ServiceGetStatisticsResponse> getStatistics(Context context) {
        context = context == null ? Context.NONE : context;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedServices().getStatisticsWithRestResponseAsync(context, null, null));
    }

    public Single<ServiceGetAccountInfoResponse> getAccountInfo(Context context) {
        context = context == null ? Context.NONE : context;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedServices().getAccountInfoWithRestResponseAsync(context));
    }
}

