/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.ICredentials;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.rest.v2.http.HttpHeader;
import com.microsoft.rest.v2.http.HttpHeaders;
import com.microsoft.rest.v2.http.HttpPipelineLogLevel;
import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.reactivex.Single;
import io.reactivex.functions.Consumer;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class SharedKeyCredentials
implements ICredentials {
    private final String accountName;
    private final byte[] accountKey;

    public SharedKeyCredentials(String accountName, String accountKey) throws InvalidKeyException {
        this.accountName = accountName;
        this.accountKey = Base64.getDecoder().decode(accountKey);
    }

    public String getAccountName() {
        return this.accountName;
    }

    public RequestPolicy create(RequestPolicy nextRequestPolicy, RequestPolicyOptions options) {
        return new SharedKeyCredentialsPolicy(this, nextRequestPolicy, options);
    }

    private String buildStringToSign(HttpRequest request) {
        HttpHeaders httpHeaders = request.headers();
        String contentLength = this.getStandardHeaderValue(httpHeaders, "Content-Length");
        contentLength = contentLength.equals("0") ? "" : contentLength;
        return String.join((CharSequence)"\n", request.httpMethod().toString(), this.getStandardHeaderValue(httpHeaders, "Content-Encoding"), this.getStandardHeaderValue(httpHeaders, "Content-Language"), contentLength, this.getStandardHeaderValue(httpHeaders, "Content-MD5"), this.getStandardHeaderValue(httpHeaders, "Content-Type"), "", this.getStandardHeaderValue(httpHeaders, "If-Modified-Since"), this.getStandardHeaderValue(httpHeaders, "If-Match"), this.getStandardHeaderValue(httpHeaders, "If-None-Match"), this.getStandardHeaderValue(httpHeaders, "If-Unmodified-Since"), this.getStandardHeaderValue(httpHeaders, "Range"), this.getAdditionalXmsHeaders(httpHeaders), this.getCanonicalizedResource(request.url()));
    }

    private void appendCanonicalizedElement(StringBuilder builder, String element) {
        builder.append("\n");
        builder.append(element);
    }

    private String getAdditionalXmsHeaders(HttpHeaders headers) {
        ArrayList<String> xmsHeaderNameArray = new ArrayList<String>();
        for (HttpHeader header : headers) {
            String lowerCaseHeader = header.name().toLowerCase(Locale.ROOT);
            if (!lowerCaseHeader.startsWith("x-ms-")) continue;
            xmsHeaderNameArray.add(lowerCaseHeader);
        }
        if (xmsHeaderNameArray.isEmpty()) {
            return "";
        }
        Collections.sort(xmsHeaderNameArray);
        StringBuilder canonicalizedHeaders = new StringBuilder();
        for (String key : xmsHeaderNameArray) {
            if (canonicalizedHeaders.length() > 0) {
                canonicalizedHeaders.append('\n');
            }
            canonicalizedHeaders.append(key);
            canonicalizedHeaders.append(':');
            canonicalizedHeaders.append(headers.value(key));
        }
        return canonicalizedHeaders.toString();
    }

    private String getCanonicalizedResource(URL requestURL) {
        StringBuilder canonicalizedResource = new StringBuilder("/");
        canonicalizedResource.append(this.accountName);
        if (requestURL.getPath().length() > 0) {
            canonicalizedResource.append(requestURL.getPath());
        } else {
            canonicalizedResource.append('/');
        }
        if (requestURL.getQuery() == null) {
            return canonicalizedResource.toString();
        }
        QueryStringDecoder queryDecoder = new QueryStringDecoder("?" + requestURL.getQuery());
        Map queryParams = queryDecoder.parameters();
        ArrayList queryParamNames = new ArrayList(queryParams.keySet());
        Collections.sort(queryParamNames);
        for (String queryParamName : queryParamNames) {
            List queryParamValues = (List)queryParams.get(queryParamName);
            Collections.sort(queryParamValues);
            String queryParamValuesStr = String.join((CharSequence)",", queryParamValues.toArray(new String[0]));
            canonicalizedResource.append("\n").append(queryParamName.toLowerCase(Locale.ROOT)).append(":").append(queryParamValuesStr);
        }
        return canonicalizedResource.toString();
    }

    private String getStandardHeaderValue(HttpHeaders httpHeaders, String headerName) {
        String headerValue = httpHeaders.value(headerName);
        return headerValue == null ? "" : headerValue;
    }

    String computeHmac256(String stringToSign) throws InvalidKeyException {
        try {
            Mac hmacSha256 = Mac.getInstance("HmacSHA256");
            hmacSha256.init(new SecretKeySpec(this.accountKey, "HmacSHA256"));
            byte[] utf8Bytes = stringToSign.getBytes("UTF-8");
            return Base64.getEncoder().encodeToString(hmacSha256.doFinal(utf8Bytes));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new Error(e);
        }
    }

    private final class SharedKeyCredentialsPolicy
    implements RequestPolicy {
        private final SharedKeyCredentials factory;
        private final RequestPolicy nextPolicy;
        private final RequestPolicyOptions options;

        SharedKeyCredentialsPolicy(SharedKeyCredentials factory, RequestPolicy nextPolicy, RequestPolicyOptions options) {
            this.factory = factory;
            this.nextPolicy = nextPolicy;
            this.options = options;
        }

        public Single<HttpResponse> sendAsync(HttpRequest request) {
            if (request.headers().value("x-ms-date") == null) {
                request.headers().set("x-ms-date", Utility.RFC1123GMTDateFormatter.format(OffsetDateTime.now()));
            }
            final String stringToSign = this.factory.buildStringToSign(request);
            try {
                String computedBase64Signature = this.factory.computeHmac256(stringToSign);
                request.headers().set("Authorization", "SharedKey " + this.factory.accountName + ":" + computedBase64Signature);
            }
            catch (Exception e) {
                return Single.error((Throwable)e);
            }
            Single response = this.nextPolicy.sendAsync(request);
            return response.doOnSuccess((Consumer)new Consumer<HttpResponse>(){

                public void accept(HttpResponse response) {
                    if (response.statusCode() == HttpResponseStatus.FORBIDDEN.code() && SharedKeyCredentialsPolicy.this.options.shouldLog(HttpPipelineLogLevel.ERROR)) {
                        SharedKeyCredentialsPolicy.this.options.log(HttpPipelineLogLevel.ERROR, "===== HTTP Forbidden status, String-to-Sign:%n'%s'%n==================%n", new Object[]{stringToSign});
                    }
                }
            });
        }
    }
}

