/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import java.util.Locale;

public final class AccountSASService {
    private boolean blob;
    private boolean file;
    private boolean queue;
    private boolean table;

    public static AccountSASService parse(String servicesString) {
        AccountSASService services = new AccountSASService();
        int i = 0;
        while (i < servicesString.length()) {
            char c = servicesString.charAt(i);
            switch (c) {
                case 'b': {
                    services.blob = true;
                    break;
                }
                case 'f': {
                    services.file = true;
                    break;
                }
                case 'q': {
                    services.queue = true;
                    break;
                }
                case 't': {
                    services.table = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Services", servicesString, Character.valueOf(c)));
                }
            }
            ++i;
        }
        return services;
    }

    public boolean blob() {
        return this.blob;
    }

    public AccountSASService withBlob(boolean blob) {
        this.blob = blob;
        return this;
    }

    public boolean file() {
        return this.file;
    }

    public AccountSASService withFile(boolean file) {
        this.file = file;
        return this;
    }

    public boolean queue() {
        return this.queue;
    }

    public AccountSASService withQueue(boolean queue) {
        this.queue = queue;
        return this;
    }

    public boolean table() {
        return this.table;
    }

    public AccountSASService withTable(boolean table) {
        this.table = table;
        return this;
    }

    public String toString() {
        StringBuilder value = new StringBuilder();
        if (this.blob) {
            value.append('b');
        }
        if (this.queue) {
            value.append('q');
        }
        if (this.table) {
            value.append('t');
        }
        if (this.file) {
            value.append('f');
        }
        return value.toString();
    }
}

