/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.AccountSASPermission;
import com.microsoft.azure.storage.blob.IPRange;
import com.microsoft.azure.storage.blob.SASProtocol;
import com.microsoft.azure.storage.blob.SASQueryParameters;
import com.microsoft.azure.storage.blob.SharedKeyCredentials;
import com.microsoft.azure.storage.blob.Utility;
import java.security.InvalidKeyException;
import java.time.OffsetDateTime;

public final class AccountSASSignatureValues {
    private String version = "2018-03-28";
    private SASProtocol protocol;
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private String permissions;
    private IPRange ipRange;
    private String services;
    private String resourceTypes;

    public String version() {
        return this.version;
    }

    public AccountSASSignatureValues withVersion(String version) {
        this.version = version;
        return this;
    }

    public SASProtocol protocol() {
        return this.protocol;
    }

    public AccountSASSignatureValues withProtocol(SASProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public AccountSASSignatureValues withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    public AccountSASSignatureValues withExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public String permissions() {
        return this.permissions;
    }

    public AccountSASSignatureValues withPermissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    public IPRange ipRange() {
        return this.ipRange;
    }

    public AccountSASSignatureValues withIpRange(IPRange ipRange) {
        this.ipRange = ipRange;
        return this;
    }

    public String services() {
        return this.services;
    }

    public AccountSASSignatureValues withServices(String services) {
        this.services = services;
        return this;
    }

    public String resourceTypes() {
        return this.resourceTypes;
    }

    public AccountSASSignatureValues withResourceTypes(String resourceTypes) {
        this.resourceTypes = resourceTypes;
        return this;
    }

    public SASQueryParameters generateSASQueryParameters(SharedKeyCredentials sharedKeyCredentials) {
        String signature;
        Utility.assertNotNull("SharedKeyCredentials", sharedKeyCredentials);
        Utility.assertNotNull("services", this.services);
        Utility.assertNotNull("resourceTypes", this.resourceTypes);
        Utility.assertNotNull("expiryTime", this.expiryTime);
        Utility.assertNotNull("permissions", this.permissions);
        Utility.assertNotNull("version", this.version);
        String stringToSign = this.stringToSign(sharedKeyCredentials);
        try {
            signature = sharedKeyCredentials.computeHmac256(stringToSign);
        }
        catch (InvalidKeyException e) {
            throw new Error(e);
        }
        return new SASQueryParameters(this.version, this.services, this.resourceTypes, this.protocol, this.startTime, this.expiryTime, this.ipRange, null, null, this.permissions, signature, null, null, null, null, null);
    }

    private String stringToSign(SharedKeyCredentials sharedKeyCredentials) {
        return String.join((CharSequence)"\n", sharedKeyCredentials.getAccountName(), AccountSASPermission.parse(this.permissions).toString(), this.services, this.resourceTypes, this.startTime == null ? "" : Utility.ISO8601UTCDateFormatter.format(this.startTime), Utility.ISO8601UTCDateFormatter.format(this.expiryTime), this.ipRange == null ? IPRange.DEFAULT.toString() : this.ipRange.toString(), this.protocol == null ? "" : this.protocol.toString(), this.version, "");
    }
}

