/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.AppendBlobAccessConditions;
import com.microsoft.azure.storage.blob.BlobAccessConditions;
import com.microsoft.azure.storage.blob.BlobURL;
import com.microsoft.azure.storage.blob.BlobURLParts;
import com.microsoft.azure.storage.blob.Metadata;
import com.microsoft.azure.storage.blob.URLParser;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.azure.storage.blob.models.AppendBlobAppendBlockResponse;
import com.microsoft.azure.storage.blob.models.AppendBlobCreateResponse;
import com.microsoft.azure.storage.blob.models.BlobHTTPHeaders;
import com.microsoft.rest.v2.Context;
import com.microsoft.rest.v2.http.HttpPipeline;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public final class AppendBlobURL
extends BlobURL {
    public static final int MAX_APPEND_BLOCK_BYTES = 0x400000;
    public static final int MAX_BLOCKS = 50000;

    public AppendBlobURL(URL url, HttpPipeline pipeline) {
        super(url, pipeline);
    }

    @Override
    public AppendBlobURL withPipeline(HttpPipeline pipeline) {
        try {
            return new AppendBlobURL(new URL(this.storageClient.url()), pipeline);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AppendBlobURL withSnapshot(String snapshot) throws MalformedURLException, UnknownHostException {
        BlobURLParts blobURLParts = URLParser.parse(new URL(this.storageClient.url()));
        blobURLParts.withSnapshot(snapshot);
        return new AppendBlobURL(blobURLParts.toURL(), this.storageClient.httpPipeline());
    }

    public Single<AppendBlobCreateResponse> create() {
        return this.create(null, null, null, null);
    }

    public Single<AppendBlobCreateResponse> create(BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions, Context context) {
        metadata = metadata == null ? Metadata.NONE : metadata;
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        context = context == null ? Context.NONE : context;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedAppendBlobs().createWithRestResponseAsync(context, 0L, null, metadata, null, headers, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions()));
    }

    public Single<AppendBlobAppendBlockResponse> appendBlock(Flowable<ByteBuffer> data, long length) {
        return this.appendBlock(data, length, null, null);
    }

    public Single<AppendBlobAppendBlockResponse> appendBlock(Flowable<ByteBuffer> data, long length, AppendBlobAccessConditions appendBlobAccessConditions, Context context) {
        appendBlobAccessConditions = appendBlobAccessConditions == null ? AppendBlobAccessConditions.NONE : appendBlobAccessConditions;
        appendBlobAccessConditions = appendBlobAccessConditions == null ? AppendBlobAccessConditions.NONE : appendBlobAccessConditions;
        context = context == null ? Context.NONE : context;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedAppendBlobs().appendBlockWithRestResponseAsync(context, data, length, null, null, null, appendBlobAccessConditions.leaseAccessConditions(), appendBlobAccessConditions.appendPositionAccessConditions(), appendBlobAccessConditions.modifiedAccessConditions()));
    }
}

