/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import java.util.Locale;

public final class BlobSASPermission {
    private boolean read;
    private boolean add;
    private boolean create;
    private boolean write;
    private boolean delete;

    public static BlobSASPermission parse(String permString) {
        BlobSASPermission permissions = new BlobSASPermission();
        int i = 0;
        while (i < permString.length()) {
            char c = permString.charAt(i);
            switch (c) {
                case 'r': {
                    permissions.read = true;
                    break;
                }
                case 'a': {
                    permissions.add = true;
                    break;
                }
                case 'c': {
                    permissions.create = true;
                    break;
                }
                case 'w': {
                    permissions.write = true;
                    break;
                }
                case 'd': {
                    permissions.delete = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Permissions", permString, Character.valueOf(c)));
                }
            }
            ++i;
        }
        return permissions;
    }

    public boolean read() {
        return this.read;
    }

    public BlobSASPermission withRead(boolean read) {
        this.read = read;
        return this;
    }

    public boolean add() {
        return this.add;
    }

    public BlobSASPermission withAdd(boolean add) {
        this.add = add;
        return this;
    }

    public boolean create() {
        return this.create;
    }

    public BlobSASPermission withCreate(boolean create) {
        this.create = create;
        return this;
    }

    public boolean write() {
        return this.write;
    }

    public BlobSASPermission withWrite(boolean write) {
        this.write = write;
        return this;
    }

    public boolean delete() {
        return this.delete;
    }

    public BlobSASPermission withDelete(boolean delete) {
        this.delete = delete;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.read) {
            builder.append('r');
        }
        if (this.add) {
            builder.append('a');
        }
        if (this.create) {
            builder.append('c');
        }
        if (this.write) {
            builder.append('w');
        }
        if (this.delete) {
            builder.append('d');
        }
        return builder.toString();
    }
}

