/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.BlobURLParts;
import com.microsoft.azure.storage.blob.LoggingOptions;
import com.microsoft.azure.storage.blob.SASQueryParameters;
import com.microsoft.azure.storage.blob.URLParser;
import com.microsoft.rest.v2.http.HttpPipelineLogLevel;
import com.microsoft.rest.v2.http.HttpRequest;
import com.microsoft.rest.v2.http.HttpResponse;
import com.microsoft.rest.v2.policy.RequestPolicy;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyOptions;
import io.reactivex.Single;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggingFactory
implements RequestPolicyFactory {
    private static final java.util.logging.Logger forceLogger = java.util.logging.Logger.getLogger("Azure Storage Java SDK");
    private static final Logger slf4jLogger = LoggerFactory.getLogger((String)"Azure Storage Java SDK");
    private static final Map<HttpPipelineLogLevel, Level> javaLogLevelMap = new HashMap<HttpPipelineLogLevel, Level>();
    private static boolean defaultLoggerLoaded;
    private final LoggingOptions loggingOptions;

    static {
        try {
            forceLogger.setLevel(Level.WARNING);
            File logDir = new File(System.getProperty("java.io.tmpdir"), "AzureStorageJavaSDKLogs");
            if (!logDir.exists() && !logDir.mkdir()) {
                throw new Exception("Could not create logs directory");
            }
            FileHandler handler = new FileHandler("%t/AzureStorageJavaSDKLogs/%u%g", 0xA00000, 5, false);
            handler.setLevel(Level.WARNING);
            forceLogger.addHandler(handler);
            javaLogLevelMap.put(HttpPipelineLogLevel.ERROR, Level.SEVERE);
            javaLogLevelMap.put(HttpPipelineLogLevel.WARNING, Level.WARNING);
            javaLogLevelMap.put(HttpPipelineLogLevel.INFO, Level.INFO);
            defaultLoggerLoaded = true;
        }
        catch (Exception e) {
            defaultLoggerLoaded = false;
            System.err.println("Azure Storage default logging could not be configured due to the following exception: " + e);
        }
    }

    public LoggingFactory(LoggingOptions loggingOptions) {
        this.loggingOptions = loggingOptions == null ? LoggingOptions.DEFAULT : loggingOptions;
    }

    public RequestPolicy create(RequestPolicy next, RequestPolicyOptions options) {
        return new LoggingPolicy(this, next, options);
    }

    private final class LoggingPolicy
    implements RequestPolicy {
        private final LoggingFactory factory;
        private final RequestPolicy nextPolicy;
        private final RequestPolicyOptions options;
        private int tryCount;
        private long operationStartTime;
        private long requestStartTime;

        private LoggingPolicy(LoggingFactory factory, RequestPolicy nextPolicy, RequestPolicyOptions options) {
            this.factory = factory;
            this.nextPolicy = nextPolicy;
            this.options = options;
        }

        public Single<HttpResponse> sendAsync(HttpRequest request) {
            ++this.tryCount;
            this.requestStartTime = System.currentTimeMillis();
            if (this.tryCount == 1) {
                this.operationStartTime = this.requestStartTime;
            }
            if (this.shouldLog(HttpPipelineLogLevel.INFO)) {
                String logMessage = String.format("'%s'==> OUTGOING REQUEST (Try number='%d')%n", request.url(), this.tryCount);
                this.log(HttpPipelineLogLevel.INFO, logMessage);
            }
            return this.nextPolicy.sendAsync(request).doOnError(throwable -> {
                if (this.shouldLog(HttpPipelineLogLevel.ERROR)) {
                    String logMessage = String.format("Unexpected failure attempting to make request.%nError message:'%s'%n", throwable.getMessage());
                    this.log(HttpPipelineLogLevel.ERROR, logMessage);
                }
            }).doOnSuccess(response -> {
                long requestEndTime = System.currentTimeMillis();
                long requestCompletionTime = requestEndTime - this.requestStartTime;
                long operationDuration = requestEndTime - this.operationStartTime;
                HttpPipelineLogLevel currentLevel = HttpPipelineLogLevel.INFO;
                String logMessage = "";
                if (this.shouldLog(HttpPipelineLogLevel.INFO)) {
                    logMessage = "Successfully Received Response" + System.lineSeparator();
                }
                if (requestCompletionTime >= this.factory.loggingOptions.minDurationToLogSlowRequestsInMs() && this.shouldLog(HttpPipelineLogLevel.WARNING)) {
                    currentLevel = HttpPipelineLogLevel.WARNING;
                    logMessage = String.format(Locale.ROOT, "SLOW OPERATION. Duration > %d ms.%n", this.factory.loggingOptions.minDurationToLogSlowRequestsInMs());
                }
                if (response.statusCode() >= 400 && response.statusCode() <= 499 && response.statusCode() != 404 && response.statusCode() != 409 && response.statusCode() != 412 && response.statusCode() != 416 || response.statusCode() >= 500 && response.statusCode() <= 509) {
                    String errorString = String.format(Locale.ROOT, "REQUEST ERROR%nHTTP request failed with status code:'%d'%n", response.statusCode());
                    logMessage = currentLevel == HttpPipelineLogLevel.WARNING ? String.valueOf(logMessage) + errorString : errorString;
                    currentLevel = HttpPipelineLogLevel.ERROR;
                }
                if (this.shouldLog(currentLevel)) {
                    String additionalMessageInfo = this.buildAdditionalMessageInfo(request);
                    String messageInfo = String.format(Locale.ROOT, "Request try:'%d', request duration:'%d' ms, operation duration:'%d' ms%n%s", this.tryCount, requestCompletionTime, operationDuration, additionalMessageInfo);
                    this.log(currentLevel, String.valueOf(logMessage) + messageInfo);
                }
            });
        }

        private String buildAdditionalMessageInfo(HttpRequest httpRequest) {
            HttpRequest sanitizedRequest = this.buildSanitizedRequest(httpRequest);
            StringBuilder stringBuilder = new StringBuilder();
            String format = "%s: %s" + System.lineSeparator();
            stringBuilder.append(String.format(format, sanitizedRequest.httpMethod().toString(), sanitizedRequest.url().toString()));
            sanitizedRequest.headers().forEach(header -> {
                StringBuilder stringBuilder2 = stringBuilder.append(String.format(format, header.name(), header.value()));
            });
            return stringBuilder.toString();
        }

        private HttpRequest buildSanitizedRequest(HttpRequest initialRequest) {
            URL url = this.sanitizeURL(initialRequest.url());
            HttpRequest resultRequest = new HttpRequest(initialRequest.callerMethod(), initialRequest.httpMethod(), url, initialRequest.headers(), initialRequest.body(), initialRequest.responseDecoder());
            if (resultRequest.headers().value("Authorization") != null) {
                resultRequest.headers().set("Authorization", "REDACTED");
            }
            if (resultRequest.headers().value("x-ms-copy-source") != null) {
                try {
                    URL copySourceUrl = this.sanitizeURL(new URL(resultRequest.headers().value("x-ms-copy-source")));
                    resultRequest.headers().set("x-ms-copy-source", copySourceUrl.toString());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            return resultRequest;
        }

        private URL sanitizeURL(URL initialURL) {
            URL resultURL = initialURL;
            try {
                BlobURLParts urlParts = URLParser.parse(initialURL);
                if (urlParts.sasQueryParameters() == null || urlParts.sasQueryParameters().signature() == null) {
                    return resultURL;
                }
                urlParts.withSasQueryParameters(new SASQueryParameters(urlParts.sasQueryParameters().version(), urlParts.sasQueryParameters().services(), urlParts.sasQueryParameters().resourceTypes(), urlParts.sasQueryParameters().protocol(), urlParts.sasQueryParameters().startTime(), urlParts.sasQueryParameters().expiryTime(), urlParts.sasQueryParameters().ipRange(), urlParts.sasQueryParameters().identifier(), urlParts.sasQueryParameters().resource(), urlParts.sasQueryParameters().permissions(), "REDACTED", urlParts.sasQueryParameters().cacheControl(), urlParts.sasQueryParameters().contentDisposition(), urlParts.sasQueryParameters().contentEncoding(), urlParts.sasQueryParameters().contentLanguage(), urlParts.sasQueryParameters().contentType()));
                resultURL = urlParts.toURL();
            }
            catch (MalformedURLException | UnknownHostException e) {
                throw new RuntimeException(e);
            }
            return resultURL;
        }

        private void log(HttpPipelineLogLevel level, String message) {
            if (this.options.shouldLog(level)) {
                this.options.log(level, message, new Object[0]);
            }
            if (!this.factory.loggingOptions.disableDefaultLogging() && defaultLoggerLoaded) {
                forceLogger.log((Level)javaLogLevelMap.get(level), message);
            }
            if (level.equals((Object)HttpPipelineLogLevel.ERROR)) {
                slf4jLogger.error(message);
            } else if (level.equals((Object)HttpPipelineLogLevel.WARNING)) {
                slf4jLogger.warn(message);
            } else if (level.equals((Object)HttpPipelineLogLevel.INFO)) {
                slf4jLogger.info(message);
            }
        }

        private boolean shouldLog(HttpPipelineLogLevel level) {
            if ((level.equals((Object)HttpPipelineLogLevel.WARNING) || level.equals((Object)HttpPipelineLogLevel.ERROR)) && !this.factory.loggingOptions.disableDefaultLogging() && defaultLoggerLoaded) {
                return true;
            }
            if (this.options.shouldLog(level)) {
                return true;
            }
            return level.equals((Object)HttpPipelineLogLevel.INFO) && slf4jLogger.isInfoEnabled() || level.equals((Object)HttpPipelineLogLevel.WARNING) && slf4jLogger.isWarnEnabled() || level.equals((Object)HttpPipelineLogLevel.ERROR) && slf4jLogger.isErrorEnabled();
        }
    }
}

