/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.BlobAccessConditions;
import com.microsoft.azure.storage.blob.BlobRange;
import com.microsoft.azure.storage.blob.BlobURL;
import com.microsoft.azure.storage.blob.BlobURLParts;
import com.microsoft.azure.storage.blob.Metadata;
import com.microsoft.azure.storage.blob.PageBlobAccessConditions;
import com.microsoft.azure.storage.blob.URLParser;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.azure.storage.blob.models.BlobHTTPHeaders;
import com.microsoft.azure.storage.blob.models.ModifiedAccessConditions;
import com.microsoft.azure.storage.blob.models.PageBlobClearPagesResponse;
import com.microsoft.azure.storage.blob.models.PageBlobCopyIncrementalResponse;
import com.microsoft.azure.storage.blob.models.PageBlobCreateResponse;
import com.microsoft.azure.storage.blob.models.PageBlobGetPageRangesDiffResponse;
import com.microsoft.azure.storage.blob.models.PageBlobGetPageRangesResponse;
import com.microsoft.azure.storage.blob.models.PageBlobResizeResponse;
import com.microsoft.azure.storage.blob.models.PageBlobUpdateSequenceNumberResponse;
import com.microsoft.azure.storage.blob.models.PageBlobUploadPagesResponse;
import com.microsoft.azure.storage.blob.models.PageRange;
import com.microsoft.azure.storage.blob.models.SequenceNumberActionType;
import com.microsoft.rest.v2.Context;
import com.microsoft.rest.v2.http.HttpPipeline;
import com.microsoft.rest.v2.http.UrlBuilder;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public final class PageBlobURL
extends BlobURL {
    public static final int PAGE_BYTES = 512;
    public static final int MAX_PUT_PAGES_BYTES = 0x400000;

    public PageBlobURL(URL url, HttpPipeline pipeline) {
        super(url, pipeline);
    }

    private static String pageRangeToString(PageRange pageRange) {
        if (pageRange.start() < 0L || pageRange.end() <= 0L) {
            throw new IllegalArgumentException("PageRange's start and end values must be greater than or equal to 0 if specified.");
        }
        if (pageRange.start() % 512L != 0L) {
            throw new IllegalArgumentException("PageRange's start value must be a multiple of 512.");
        }
        if (pageRange.end() % 512L != 511L) {
            throw new IllegalArgumentException("PageRange's end value must be 1 less than a multiple of 512.");
        }
        if (pageRange.end() <= pageRange.start()) {
            throw new IllegalArgumentException("PageRange's End value must be after the start.");
        }
        return "bytes=" + pageRange.start() + '-' + pageRange.end();
    }

    @Override
    public PageBlobURL withPipeline(HttpPipeline pipeline) {
        try {
            return new PageBlobURL(new URL(this.storageClient.url()), pipeline);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PageBlobURL withSnapshot(String snapshot) throws MalformedURLException, UnknownHostException {
        BlobURLParts blobURLParts = URLParser.parse(new URL(this.storageClient.url()));
        blobURLParts.withSnapshot(snapshot);
        return new PageBlobURL(blobURLParts.toURL(), this.storageClient.httpPipeline());
    }

    public Single<PageBlobCreateResponse> create(long size) {
        return this.create(size, null, null, null, null, null);
    }

    public Single<PageBlobCreateResponse> create(long size, Long sequenceNumber, BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions, Context context) {
        BlobAccessConditions blobAccessConditions = accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        if (size % 512L != 0L) {
            throw new IllegalArgumentException("size must be a multiple of PageBlobURL.PAGE_BYTES.");
        }
        if (sequenceNumber != null && sequenceNumber < 0L) {
            throw new IllegalArgumentException("SequenceNumber must be greater than or equal to 0.");
        }
        metadata = metadata == null ? Metadata.NONE : metadata;
        context = context == null ? Context.NONE : context;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedPageBlobs().createWithRestResponseAsync(context, 0L, size, null, metadata, sequenceNumber, null, headers, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions()));
    }

    public Single<PageBlobUploadPagesResponse> uploadPages(PageRange pageRange, Flowable<ByteBuffer> body) {
        return this.uploadPages(pageRange, body, null, null);
    }

    public Single<PageBlobUploadPagesResponse> uploadPages(PageRange pageRange, Flowable<ByteBuffer> body, PageBlobAccessConditions pageBlobAccessConditions, Context context) {
        PageBlobAccessConditions pageBlobAccessConditions2 = pageBlobAccessConditions = pageBlobAccessConditions == null ? PageBlobAccessConditions.NONE : pageBlobAccessConditions;
        if (pageRange == null) {
            throw new IllegalArgumentException("pageRange cannot be null.");
        }
        String pageRangeStr = PageBlobURL.pageRangeToString(pageRange);
        context = context == null ? Context.NONE : context;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedPageBlobs().uploadPagesWithRestResponseAsync(context, body, pageRange.end() - pageRange.start() + 1L, null, null, pageRangeStr, null, pageBlobAccessConditions.leaseAccessConditions(), pageBlobAccessConditions.sequenceNumberAccessConditions(), pageBlobAccessConditions.modifiedAccessConditions()));
    }

    public Single<PageBlobClearPagesResponse> clearPages(PageRange pageRange) {
        return this.clearPages(pageRange, null, null);
    }

    public Single<PageBlobClearPagesResponse> clearPages(PageRange pageRange, PageBlobAccessConditions pageBlobAccessConditions, Context context) {
        PageBlobAccessConditions pageBlobAccessConditions2 = pageBlobAccessConditions = pageBlobAccessConditions == null ? PageBlobAccessConditions.NONE : pageBlobAccessConditions;
        if (pageRange == null) {
            throw new IllegalArgumentException("pageRange cannot be null.");
        }
        String pageRangeStr = PageBlobURL.pageRangeToString(pageRange);
        context = context == null ? Context.NONE : context;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedPageBlobs().clearPagesWithRestResponseAsync(context, 0L, null, pageRangeStr, null, pageBlobAccessConditions.leaseAccessConditions(), pageBlobAccessConditions.sequenceNumberAccessConditions(), pageBlobAccessConditions.modifiedAccessConditions()));
    }

    public Single<PageBlobGetPageRangesResponse> getPageRanges(BlobRange blobRange) {
        return this.getPageRanges(blobRange, null, null);
    }

    public Single<PageBlobGetPageRangesResponse> getPageRanges(BlobRange blobRange, BlobAccessConditions accessConditions, Context context) {
        blobRange = blobRange == null ? BlobRange.DEFAULT : blobRange;
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        context = context == null ? Context.NONE : context;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedPageBlobs().getPageRangesWithRestResponseAsync(context, null, null, blobRange.toString(), null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions()));
    }

    public Single<PageBlobGetPageRangesDiffResponse> getPageRangesDiff(BlobRange blobRange, String prevSnapshot) {
        return this.getPageRangesDiff(blobRange, prevSnapshot, null, null);
    }

    public Single<PageBlobGetPageRangesDiffResponse> getPageRangesDiff(BlobRange blobRange, String prevSnapshot, BlobAccessConditions accessConditions, Context context) {
        blobRange = blobRange == null ? BlobRange.DEFAULT : blobRange;
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        Context context2 = context = context == null ? Context.NONE : context;
        if (prevSnapshot == null) {
            throw new IllegalArgumentException("prevSnapshot cannot be null");
        }
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedPageBlobs().getPageRangesDiffWithRestResponseAsync(context, null, null, prevSnapshot, blobRange.toString(), null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions()));
    }

    public Single<PageBlobResizeResponse> resize(long size) {
        return this.resize(size, null, null);
    }

    public Single<PageBlobResizeResponse> resize(long size, BlobAccessConditions accessConditions, Context context) {
        if (size % 512L != 0L) {
            throw new IllegalArgumentException("size must be a multiple of PageBlobURL.PAGE_BYTES.");
        }
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        context = context == null ? Context.NONE : context;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedPageBlobs().resizeWithRestResponseAsync(context, size, null, null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions()));
    }

    public Single<PageBlobUpdateSequenceNumberResponse> updateSequenceNumber(SequenceNumberActionType action, Long sequenceNumber) {
        return this.updateSequenceNumber(action, sequenceNumber, null, null);
    }

    public Single<PageBlobUpdateSequenceNumberResponse> updateSequenceNumber(SequenceNumberActionType action, Long sequenceNumber, BlobAccessConditions accessConditions, Context context) {
        if (sequenceNumber != null && sequenceNumber < 0L) {
            throw new IllegalArgumentException("SequenceNumber must be greater than or equal to 0.");
        }
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        sequenceNumber = action == SequenceNumberActionType.INCREMENT ? null : sequenceNumber;
        context = context == null ? Context.NONE : context;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedPageBlobs().updateSequenceNumberWithRestResponseAsync(context, action, null, sequenceNumber, null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions()));
    }

    public Single<PageBlobCopyIncrementalResponse> copyIncremental(URL source, String snapshot) {
        return this.copyIncremental(source, snapshot, null, null);
    }

    public Single<PageBlobCopyIncrementalResponse> copyIncremental(URL source, String snapshot, ModifiedAccessConditions modifiedAccessConditions, Context context) {
        context = context == null ? Context.NONE : context;
        UrlBuilder builder = UrlBuilder.parse((URL)source);
        builder.setQueryParameter("snapshot", snapshot);
        try {
            source = builder.toURL();
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedPageBlobs().copyIncrementalWithRestResponseAsync(context, source, null, null, modifiedAccessConditions));
    }
}

