/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.GeneratedStorageClient;
import com.microsoft.azure.storage.blob.AnonymousCredentials;
import com.microsoft.azure.storage.blob.ICredentials;
import com.microsoft.azure.storage.blob.LoggingFactory;
import com.microsoft.azure.storage.blob.PipelineOptions;
import com.microsoft.azure.storage.blob.RequestIDFactory;
import com.microsoft.azure.storage.blob.RequestRetryFactory;
import com.microsoft.azure.storage.blob.SetResponseFieldFactory;
import com.microsoft.azure.storage.blob.TelemetryFactory;
import com.microsoft.rest.v2.http.HttpPipeline;
import com.microsoft.rest.v2.http.HttpPipelineOptions;
import com.microsoft.rest.v2.http.UrlBuilder;
import com.microsoft.rest.v2.policy.DecodingPolicyFactory;
import com.microsoft.rest.v2.policy.RequestPolicyFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public abstract class StorageURL {
    protected final GeneratedStorageClient storageClient;

    protected StorageURL(URL url, HttpPipeline pipeline) {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null.");
        }
        if (pipeline == null) {
            throw new IllegalArgumentException("Pipeline cannot be null. Create a pipeline by calling StorageURL.createPipeline.");
        }
        this.storageClient = new GeneratedStorageClient(pipeline).withVersion("2018-03-28");
        this.storageClient.withUrl(url.toString());
    }

    protected static URL appendToURLPath(URL baseURL, String name) throws MalformedURLException {
        UrlBuilder url = UrlBuilder.parse((String)baseURL.toString());
        if (url.path() == null) {
            url.withPath("/");
        } else if (url.path().charAt(url.path().length() - 1) != '/') {
            url.withPath(String.valueOf(url.path()) + '/');
        }
        url.withPath(String.valueOf(url.path()) + name);
        return new URL(url.toString());
    }

    public static HttpPipeline createPipeline() {
        return StorageURL.createPipeline(new AnonymousCredentials(), new PipelineOptions());
    }

    public static HttpPipeline createPipeline(ICredentials credentials) {
        return StorageURL.createPipeline(credentials, new PipelineOptions());
    }

    public static HttpPipeline createPipeline(PipelineOptions pipelineOptions) {
        return StorageURL.createPipeline(new AnonymousCredentials(), pipelineOptions);
    }

    public static HttpPipeline createPipeline(ICredentials credentials, PipelineOptions pipelineOptions) {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials cannot be null. For anonymous access use Anonymous Credentials.");
        }
        if (pipelineOptions == null) {
            throw new IllegalArgumentException("pipelineOptions cannot be null. You must at least specify a client.");
        }
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new TelemetryFactory(pipelineOptions.telemetryOptions()));
        factories.add(new RequestIDFactory());
        factories.add(new RequestRetryFactory(pipelineOptions.requestRetryOptions()));
        if (!(credentials instanceof AnonymousCredentials)) {
            factories.add(credentials);
        }
        factories.add(new SetResponseFieldFactory());
        factories.add(new DecodingPolicyFactory());
        factories.add(new LoggingFactory(pipelineOptions.loggingOptions()));
        return HttpPipeline.build((HttpPipelineOptions)new HttpPipelineOptions().withHttpClient(pipelineOptions.client()).withLogger(pipelineOptions.logger()), (RequestPolicyFactory[])factories.toArray(new RequestPolicyFactory[factories.size()]));
    }

    public String toString() {
        return this.storageClient.url();
    }

    public URL toURL() {
        try {
            return new URL(this.storageClient.url());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

