/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.microsoft.azure.storage.blob.models.LeaseDurationType;
import com.microsoft.azure.storage.blob.models.LeaseStateType;
import com.microsoft.azure.storage.blob.models.LeaseStatusType;
import com.microsoft.azure.storage.blob.models.PublicAccessType;
import com.microsoft.rest.v2.DateTimeRfc1123;
import com.microsoft.rest.v2.annotations.HeaderCollection;
import java.time.OffsetDateTime;
import java.util.Map;

@JacksonXmlRootElement(localName="Container-GetProperties-Headers")
public final class ContainerGetPropertiesHeaders {
    @HeaderCollection(value="x-ms-meta-")
    private Map<String, String> metadata;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-lease-duration")
    private LeaseDurationType leaseDuration;
    @JsonProperty(value="x-ms-lease-state")
    private LeaseStateType leaseState;
    @JsonProperty(value="x-ms-lease-status")
    private LeaseStatusType leaseStatus;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;
    @JsonProperty(value="x-ms-blob-public-access")
    private PublicAccessType blobPublicAccess;
    @JsonProperty(value="x-ms-has-immutability-policy")
    private Boolean hasImmutabilityPolicy;
    @JsonProperty(value="x-ms-has-legal-hold")
    private Boolean hasLegalHold;

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public ContainerGetPropertiesHeaders withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public String eTag() {
        return this.eTag;
    }

    public ContainerGetPropertiesHeaders withETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public OffsetDateTime lastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.dateTime();
    }

    public ContainerGetPropertiesHeaders withLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public LeaseDurationType leaseDuration() {
        return this.leaseDuration;
    }

    public ContainerGetPropertiesHeaders withLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public LeaseStateType leaseState() {
        return this.leaseState;
    }

    public ContainerGetPropertiesHeaders withLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseStatusType leaseStatus() {
        return this.leaseStatus;
    }

    public ContainerGetPropertiesHeaders withLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public String requestId() {
        return this.requestId;
    }

    public ContainerGetPropertiesHeaders withRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String version() {
        return this.version;
    }

    public ContainerGetPropertiesHeaders withVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime date() {
        if (this.date == null) {
            return null;
        }
        return this.date.dateTime();
    }

    public ContainerGetPropertiesHeaders withDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public PublicAccessType blobPublicAccess() {
        return this.blobPublicAccess;
    }

    public ContainerGetPropertiesHeaders withBlobPublicAccess(PublicAccessType blobPublicAccess) {
        this.blobPublicAccess = blobPublicAccess;
        return this;
    }

    public Boolean hasImmutabilityPolicy() {
        return this.hasImmutabilityPolicy;
    }

    public ContainerGetPropertiesHeaders withHasImmutabilityPolicy(Boolean hasImmutabilityPolicy) {
        this.hasImmutabilityPolicy = hasImmutabilityPolicy;
        return this;
    }

    public Boolean hasLegalHold() {
        return this.hasLegalHold;
    }

    public ContainerGetPropertiesHeaders withHasLegalHold(Boolean hasLegalHold) {
        this.hasLegalHold = hasLegalHold;
        return this;
    }
}

