/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.GeneratedStorageClient;
import com.microsoft.azure.storage.blob.models.KeyInfo;
import com.microsoft.azure.storage.blob.models.ListContainersIncludeType;
import com.microsoft.azure.storage.blob.models.ListContainersSegmentResponse;
import com.microsoft.azure.storage.blob.models.ServiceGetAccountInfoResponse;
import com.microsoft.azure.storage.blob.models.ServiceGetPropertiesResponse;
import com.microsoft.azure.storage.blob.models.ServiceGetStatisticsResponse;
import com.microsoft.azure.storage.blob.models.ServiceGetUserDelegationKeyResponse;
import com.microsoft.azure.storage.blob.models.ServiceListContainersSegmentResponse;
import com.microsoft.azure.storage.blob.models.ServiceSetPropertiesResponse;
import com.microsoft.azure.storage.blob.models.StorageErrorException;
import com.microsoft.azure.storage.blob.models.StorageServiceProperties;
import com.microsoft.azure.storage.blob.models.StorageServiceStats;
import com.microsoft.azure.storage.blob.models.UserDelegationKey;
import com.microsoft.rest.v2.Context;
import com.microsoft.rest.v2.RestProxy;
import com.microsoft.rest.v2.ServiceCallback;
import com.microsoft.rest.v2.ServiceClient;
import com.microsoft.rest.v2.ServiceFuture;
import com.microsoft.rest.v2.Validator;
import com.microsoft.rest.v2.annotations.BodyParam;
import com.microsoft.rest.v2.annotations.ExpectedResponses;
import com.microsoft.rest.v2.annotations.GET;
import com.microsoft.rest.v2.annotations.HeaderParam;
import com.microsoft.rest.v2.annotations.Host;
import com.microsoft.rest.v2.annotations.HostParam;
import com.microsoft.rest.v2.annotations.POST;
import com.microsoft.rest.v2.annotations.PUT;
import com.microsoft.rest.v2.annotations.QueryParam;
import com.microsoft.rest.v2.annotations.UnexpectedResponseExceptionType;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.annotations.NonNull;

public final class GeneratedServices {
    private ServicesService service;
    private GeneratedStorageClient client;

    public GeneratedServices(GeneratedStorageClient client) {
        this.service = (ServicesService)RestProxy.create(ServicesService.class, (ServiceClient)client);
        this.client = client;
    }

    public void setProperties(Context context, @NonNull StorageServiceProperties storageServiceProperties, Integer timeout, String requestId) {
        this.setPropertiesAsync(context, storageServiceProperties, timeout, requestId).blockingAwait();
    }

    public ServiceFuture<Void> setPropertiesAsync(Context context, @NonNull StorageServiceProperties storageServiceProperties, Integer timeout, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.setPropertiesAsync(context, storageServiceProperties, timeout, requestId), serviceCallback);
    }

    public Single<ServiceSetPropertiesResponse> setPropertiesWithRestResponseAsync(Context context, @NonNull StorageServiceProperties storageServiceProperties, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (storageServiceProperties == null) {
            throw new IllegalArgumentException("Parameter storageServiceProperties is required and cannot be null.");
        }
        Validator.validate((Object)storageServiceProperties);
        return this.service.setProperties(context, this.client.url(), storageServiceProperties, timeout, this.client.version(), requestId, "service", "properties");
    }

    public Completable setPropertiesAsync(Context context, @NonNull StorageServiceProperties storageServiceProperties, Integer timeout, String requestId) {
        return this.setPropertiesWithRestResponseAsync(context, storageServiceProperties, timeout, requestId).toCompletable();
    }

    public StorageServiceProperties getProperties(Context context, Integer timeout, String requestId) {
        return (StorageServiceProperties)this.getPropertiesAsync(context, timeout, requestId).blockingGet();
    }

    public ServiceFuture<StorageServiceProperties> getPropertiesAsync(Context context, Integer timeout, String requestId, ServiceCallback<StorageServiceProperties> serviceCallback) {
        return ServiceFuture.fromBody(this.getPropertiesAsync(context, timeout, requestId), serviceCallback);
    }

    public Single<ServiceGetPropertiesResponse> getPropertiesWithRestResponseAsync(Context context, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        return this.service.getProperties(context, this.client.url(), timeout, this.client.version(), requestId, "service", "properties");
    }

    public Maybe<StorageServiceProperties> getPropertiesAsync(Context context, Integer timeout, String requestId) {
        return this.getPropertiesWithRestResponseAsync(context, timeout, requestId).flatMapMaybe(res -> res.body() == null ? Maybe.empty() : Maybe.just((Object)res.body()));
    }

    public StorageServiceStats getStatistics(Context context, Integer timeout, String requestId) {
        return (StorageServiceStats)this.getStatisticsAsync(context, timeout, requestId).blockingGet();
    }

    public ServiceFuture<StorageServiceStats> getStatisticsAsync(Context context, Integer timeout, String requestId, ServiceCallback<StorageServiceStats> serviceCallback) {
        return ServiceFuture.fromBody(this.getStatisticsAsync(context, timeout, requestId), serviceCallback);
    }

    public Single<ServiceGetStatisticsResponse> getStatisticsWithRestResponseAsync(Context context, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        return this.service.getStatistics(context, this.client.url(), timeout, this.client.version(), requestId, "service", "stats");
    }

    public Maybe<StorageServiceStats> getStatisticsAsync(Context context, Integer timeout, String requestId) {
        return this.getStatisticsWithRestResponseAsync(context, timeout, requestId).flatMapMaybe(res -> res.body() == null ? Maybe.empty() : Maybe.just((Object)res.body()));
    }

    public ListContainersSegmentResponse listContainersSegment(Context context, String prefix, String marker, Integer maxresults, ListContainersIncludeType include, Integer timeout, String requestId) {
        return (ListContainersSegmentResponse)this.listContainersSegmentAsync(context, prefix, marker, maxresults, include, timeout, requestId).blockingGet();
    }

    public ServiceFuture<ListContainersSegmentResponse> listContainersSegmentAsync(Context context, String prefix, String marker, Integer maxresults, ListContainersIncludeType include, Integer timeout, String requestId, ServiceCallback<ListContainersSegmentResponse> serviceCallback) {
        return ServiceFuture.fromBody(this.listContainersSegmentAsync(context, prefix, marker, maxresults, include, timeout, requestId), serviceCallback);
    }

    public Single<ServiceListContainersSegmentResponse> listContainersSegmentWithRestResponseAsync(Context context, String prefix, String marker, Integer maxresults, ListContainersIncludeType include, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        return this.service.listContainersSegment(context, this.client.url(), prefix, marker, maxresults, include, timeout, this.client.version(), requestId, "list");
    }

    public Maybe<ListContainersSegmentResponse> listContainersSegmentAsync(Context context, String prefix, String marker, Integer maxresults, ListContainersIncludeType include, Integer timeout, String requestId) {
        return this.listContainersSegmentWithRestResponseAsync(context, prefix, marker, maxresults, include, timeout, requestId).flatMapMaybe(res -> res.body() == null ? Maybe.empty() : Maybe.just((Object)res.body()));
    }

    public UserDelegationKey getUserDelegationKey(Context context, @NonNull KeyInfo keyInfo, Integer timeout, String requestId) {
        return (UserDelegationKey)this.getUserDelegationKeyAsync(context, keyInfo, timeout, requestId).blockingGet();
    }

    public ServiceFuture<UserDelegationKey> getUserDelegationKeyAsync(Context context, @NonNull KeyInfo keyInfo, Integer timeout, String requestId, ServiceCallback<UserDelegationKey> serviceCallback) {
        return ServiceFuture.fromBody(this.getUserDelegationKeyAsync(context, keyInfo, timeout, requestId), serviceCallback);
    }

    public Single<ServiceGetUserDelegationKeyResponse> getUserDelegationKeyWithRestResponseAsync(Context context, @NonNull KeyInfo keyInfo, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (keyInfo == null) {
            throw new IllegalArgumentException("Parameter keyInfo is required and cannot be null.");
        }
        Validator.validate((Object)keyInfo);
        return this.service.getUserDelegationKey(context, this.client.url(), keyInfo, timeout, this.client.version(), requestId, "service", "userdelegationkey");
    }

    public Maybe<UserDelegationKey> getUserDelegationKeyAsync(Context context, @NonNull KeyInfo keyInfo, Integer timeout, String requestId) {
        return this.getUserDelegationKeyWithRestResponseAsync(context, keyInfo, timeout, requestId).flatMapMaybe(res -> res.body() == null ? Maybe.empty() : Maybe.just((Object)res.body()));
    }

    public void getAccountInfo(Context context) {
        this.getAccountInfoAsync(context).blockingAwait();
    }

    public ServiceFuture<Void> getAccountInfoAsync(Context context, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.getAccountInfoAsync(context), serviceCallback);
    }

    public Single<ServiceGetAccountInfoResponse> getAccountInfoWithRestResponseAsync(Context context) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        return this.service.getAccountInfo(context, this.client.url(), this.client.version(), "account", "properties");
    }

    public Completable getAccountInfoAsync(Context context) {
        return this.getAccountInfoWithRestResponseAsync(context).toCompletable();
    }

    @Host(value="{url}")
    private static interface ServicesService {
        @PUT(value="")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ServiceSetPropertiesResponse> setProperties(Context var1, @HostParam(value="url") String var2, @BodyParam(value="application/xml; charset=utf-8") StorageServiceProperties var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="restype") String var7, @QueryParam(value="comp") String var8);

        @GET(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ServiceGetPropertiesResponse> getProperties(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7);

        @GET(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ServiceGetStatisticsResponse> getStatistics(Context var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7);

        @GET(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ServiceListContainersSegmentResponse> listContainersSegment(Context var1, @HostParam(value="url") String var2, @QueryParam(value="prefix") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") ListContainersIncludeType var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @QueryParam(value="comp") String var10);

        @POST(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ServiceGetUserDelegationKeyResponse> getUserDelegationKey(Context var1, @HostParam(value="url") String var2, @BodyParam(value="application/xml; charset=utf-8") KeyInfo var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="restype") String var7, @QueryParam(value="comp") String var8);

        @GET(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ServiceGetAccountInfoResponse> getAccountInfo(Context var1, @HostParam(value="url") String var2, @HeaderParam(value="x-ms-version") String var3, @QueryParam(value="restype") String var4, @QueryParam(value="comp") String var5);
    }
}

