/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.BlobAccessConditions;
import com.microsoft.azure.storage.blob.IProgressReceiver;
import com.microsoft.azure.storage.blob.ReliableDownloadOptions;
import com.microsoft.azure.storage.blob.Utility;

public final class TransferManagerDownloadFromBlobOptions {
    private final long chunkSize;
    private final IProgressReceiver progressReceiver;
    private final int parallelism;
    private final ReliableDownloadOptions reliableDownloadOptionsPerBlock;
    private BlobAccessConditions accessConditions;

    public TransferManagerDownloadFromBlobOptions() {
        this(null, null, null, null, null);
    }

    public TransferManagerDownloadFromBlobOptions(Long chunkSize, IProgressReceiver progressReceiver, BlobAccessConditions accessConditions, ReliableDownloadOptions reliableDownloadOptions, Integer parallelism) {
        this.progressReceiver = progressReceiver;
        if (chunkSize != null) {
            Utility.assertInBounds("chunkSize", chunkSize, 1L, Long.MAX_VALUE);
            this.chunkSize = chunkSize;
        } else {
            this.chunkSize = 0x400000L;
        }
        if (parallelism != null) {
            Utility.assertInBounds("parallelism", parallelism.intValue(), 1L, Integer.MAX_VALUE);
            this.parallelism = parallelism;
        } else {
            this.parallelism = 5;
        }
        this.accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        this.reliableDownloadOptionsPerBlock = reliableDownloadOptions == null ? new ReliableDownloadOptions() : reliableDownloadOptions;
    }

    public long chunkSize() {
        return this.chunkSize;
    }

    public IProgressReceiver progressReceiver() {
        return this.progressReceiver;
    }

    public int parallelism() {
        return this.parallelism;
    }

    public ReliableDownloadOptions reliableDownloadOptionsPerBlock() {
        return this.reliableDownloadOptionsPerBlock;
    }

    public BlobAccessConditions accessConditions() {
        return this.accessConditions;
    }
}

