/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.microsoft.azure.storage.blob.models.PublicAccessType;
import com.microsoft.rest.v2.DateTimeRfc1123;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="Container-GetAccessPolicy-Headers")
public final class ContainerGetAccessPolicyHeaders {
    @JsonProperty(value="x-ms-blob-public-access")
    private PublicAccessType blobPublicAccess;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 date;

    public PublicAccessType blobPublicAccess() {
        return this.blobPublicAccess;
    }

    public ContainerGetAccessPolicyHeaders withBlobPublicAccess(PublicAccessType blobPublicAccess) {
        this.blobPublicAccess = blobPublicAccess;
        return this;
    }

    public String eTag() {
        return this.eTag;
    }

    public ContainerGetAccessPolicyHeaders withETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public OffsetDateTime lastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.dateTime();
    }

    public ContainerGetAccessPolicyHeaders withLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String requestId() {
        return this.requestId;
    }

    public ContainerGetAccessPolicyHeaders withRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String version() {
        return this.version;
    }

    public ContainerGetAccessPolicyHeaders withVersion(String version) {
        this.version = version;
        return this;
    }

    public OffsetDateTime date() {
        if (this.date == null) {
            return null;
        }
        return this.date.dateTime();
    }

    public ContainerGetAccessPolicyHeaders withDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }
}

