/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import com.microsoft.azure.kusto.data.Client;
import com.microsoft.azure.kusto.data.ClientRequestProperties;
import com.microsoft.azure.kusto.data.CommandType;
import com.microsoft.azure.kusto.data.KustoOperationResult;
import com.microsoft.azure.kusto.data.StreamingClient;
import com.microsoft.azure.kusto.data.Utils;
import com.microsoft.azure.kusto.data.auth.ConnectionStringBuilder;
import com.microsoft.azure.kusto.data.auth.TokenProviderBase;
import com.microsoft.azure.kusto.data.auth.TokenProviderFactory;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import com.microsoft.azure.kusto.data.exceptions.KustoServiceQueryError;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientImpl
implements Client,
StreamingClient {
    private static final String ADMIN_COMMANDS_PREFIX = ".";
    public static final String MGMT_ENDPOINT_VERSION = "v1";
    public static final String QUERY_ENDPOINT_VERSION = "v2";
    public static final String STREAMING_VERSION = "v1";
    private static final String DEFAULT_DATABASE_NAME = "NetDefaultDb";
    private static final Long COMMAND_TIMEOUT_IN_MILLISECS = TimeUnit.MINUTES.toMillis(10L);
    private static final Long QUERY_TIMEOUT_IN_MILLISECS = TimeUnit.MINUTES.toMillis(4L);
    private static final Long STREAMING_INGEST_TIMEOUT_IN_MILLISECS = TimeUnit.MINUTES.toMillis(10L);
    private static final int CLIENT_SERVER_DELTA_IN_MILLISECS = (int)TimeUnit.SECONDS.toMillis(30L);
    public static final String FEDERATED_SECURITY_SUFFIX = ";fed=true";
    public static final String JAVA_INGEST_ACTIVITY_TYPE_PREFIX = "DN.JavaClient.Execute";
    private final TokenProviderBase aadAuthenticationHelper;
    private final String clusterUrl;
    private String clientVersionForTracing;
    private final String applicationNameForTracing;
    private final String userNameForTracing;

    public ClientImpl(ConnectionStringBuilder csb) throws URISyntaxException {
        URI clusterUrlForParsing = new URI(csb.getClusterUrl());
        String host = clusterUrlForParsing.getHost();
        Objects.requireNonNull(clusterUrlForParsing.getAuthority(), "clusterUri.authority");
        String auth = clusterUrlForParsing.getAuthority().toLowerCase();
        if (host == null && auth.endsWith(FEDERATED_SECURITY_SUFFIX)) {
            csb.setClusterUrl(new URIBuilder().setScheme(clusterUrlForParsing.getScheme()).setHost(auth.substring(0, clusterUrlForParsing.getAuthority().indexOf(FEDERATED_SECURITY_SUFFIX))).toString());
        }
        this.clusterUrl = csb.getClusterUrl();
        this.aadAuthenticationHelper = this.clusterUrl.toLowerCase().startsWith("http://localhost") ? null : TokenProviderFactory.createTokenProvider(csb);
        this.clientVersionForTracing = "Kusto.Java.Client";
        String version = Utils.getPackageVersion();
        if (StringUtils.isNotBlank((CharSequence)version)) {
            this.clientVersionForTracing = this.clientVersionForTracing + ":" + version;
        }
        if (StringUtils.isNotBlank((CharSequence)csb.getClientVersionForTracing())) {
            this.clientVersionForTracing = this.clientVersionForTracing + "[" + csb.getClientVersionForTracing() + "]";
        }
        this.applicationNameForTracing = csb.getApplicationNameForTracing();
        this.userNameForTracing = csb.getUserNameForTracing();
    }

    @Override
    public KustoOperationResult execute(String command) throws DataServiceException, DataClientException {
        return this.execute(DEFAULT_DATABASE_NAME, command);
    }

    @Override
    public KustoOperationResult execute(String database, String command) throws DataServiceException, DataClientException {
        return this.execute(database, command, null);
    }

    @Override
    public KustoOperationResult execute(String database, String command, ClientRequestProperties properties) throws DataServiceException, DataClientException {
        String response = this.executeToJsonResult(database, command, properties);
        CommandType commandType = this.determineCommandType(command);
        String clusterEndpoint = String.format(commandType.getEndpoint(), this.clusterUrl);
        try {
            return new KustoOperationResult(response, clusterEndpoint.endsWith("v2/rest/query") ? QUERY_ENDPOINT_VERSION : "v1");
        }
        catch (KustoServiceQueryError e) {
            throw new DataServiceException(clusterEndpoint, "Error found while parsing json response as KustoOperationResult:" + e.getMessage(), e, e.isPermanent());
        }
        catch (Exception e) {
            throw new DataClientException(clusterEndpoint, e.getMessage(), e);
        }
    }

    @Override
    public String executeToJsonResult(String command) throws DataServiceException, DataClientException {
        return this.executeToJsonResult(DEFAULT_DATABASE_NAME, command);
    }

    @Override
    public String executeToJsonResult(String database, String command) throws DataServiceException, DataClientException {
        return this.executeToJsonResult(database, command, null);
    }

    @Override
    public String executeToJsonResult(String database, String command, ClientRequestProperties properties) throws DataServiceException, DataClientException {
        if (StringUtils.isEmpty((CharSequence)database)) {
            throw new IllegalArgumentException("Database is empty");
        }
        if (StringUtils.isEmpty((CharSequence)command)) {
            throw new IllegalArgumentException("Command is empty");
        }
        command = command.trim();
        CommandType commandType = this.determineCommandType(command);
        long timeoutMs = this.determineTimeout(properties, commandType);
        String clusterEndpoint = String.format(commandType.getEndpoint(), this.clusterUrl);
        Map<String, String> headers = this.generateIngestAndCommandHeaders(properties, "KJC.execute", commandType.getActivityTypeSuffix());
        this.addCommandHeaders(headers);
        String jsonPayload = this.generateCommandPayload(database, command, properties, clusterEndpoint);
        return Utils.post(clusterEndpoint, jsonPayload, null, timeoutMs + (long)CLIENT_SERVER_DELTA_IN_MILLISECS, headers, false);
    }

    @Override
    public KustoOperationResult executeStreamingIngest(String database, String table, InputStream stream, ClientRequestProperties properties, String streamFormat, String mappingName, boolean leaveOpen) throws DataServiceException, DataClientException {
        if (stream == null) {
            throw new IllegalArgumentException("The provided stream is null.");
        }
        if (StringUtils.isBlank((CharSequence)database)) {
            throw new IllegalArgumentException("Parameter database is empty.");
        }
        if (StringUtils.isBlank((CharSequence)table)) {
            throw new IllegalArgumentException("Parameter table is empty.");
        }
        if (StringUtils.isBlank((CharSequence)streamFormat)) {
            throw new IllegalArgumentException("Parameter streamFormat is empty.");
        }
        String clusterEndpoint = String.format(CommandType.STREAMING_INGEST.getEndpoint(), this.clusterUrl, database, table, streamFormat);
        if (!StringUtils.isEmpty((CharSequence)mappingName)) {
            clusterEndpoint = clusterEndpoint.concat(String.format("&mappingName=%s", mappingName));
        }
        Map<String, String> headers = this.generateIngestAndCommandHeaders(properties, "KJC.executeStreamingIngest", CommandType.STREAMING_INGEST.getActivityTypeSuffix());
        Long timeoutMs = null;
        if (properties != null) {
            timeoutMs = properties.getTimeoutInMilliSec();
            Iterator<Map.Entry<String, Object>> iterator = properties.getOptions();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> pair = iterator.next();
                headers.put(pair.getKey(), pair.getValue().toString());
            }
        }
        headers.put("Content-Encoding", "gzip");
        if (timeoutMs == null) {
            timeoutMs = STREAMING_INGEST_TIMEOUT_IN_MILLISECS;
        }
        String response = Utils.post(clusterEndpoint, null, stream, timeoutMs + (long)CLIENT_SERVER_DELTA_IN_MILLISECS, headers, leaveOpen);
        try {
            return new KustoOperationResult(response, "v1");
        }
        catch (KustoServiceQueryError e) {
            throw new DataClientException(clusterEndpoint, "Error converting json response to KustoOperationResult:" + e.getMessage(), e);
        }
    }

    @Override
    public InputStream executeStreamingQuery(String command) throws DataServiceException, DataClientException {
        return this.executeStreamingQuery(DEFAULT_DATABASE_NAME, command);
    }

    @Override
    public InputStream executeStreamingQuery(String database, String command) throws DataServiceException, DataClientException {
        return this.executeStreamingQuery(database, command, null);
    }

    @Override
    public InputStream executeStreamingQuery(String database, String command, ClientRequestProperties properties) throws DataServiceException, DataClientException {
        if (StringUtils.isEmpty((CharSequence)database)) {
            throw new IllegalArgumentException("Database is empty");
        }
        if (StringUtils.isEmpty((CharSequence)command)) {
            throw new IllegalArgumentException("Command is empty");
        }
        command = command.trim();
        CommandType commandType = this.determineCommandType(command);
        long timeoutMs = this.determineTimeout(properties, commandType);
        String clusterEndpoint = String.format(commandType.getEndpoint(), this.clusterUrl);
        Map<String, String> headers = this.generateIngestAndCommandHeaders(properties, "KJC.executeStreaming", commandType.getActivityTypeSuffix());
        this.addCommandHeaders(headers);
        String jsonPayload = this.generateCommandPayload(database, command, properties, clusterEndpoint);
        return Utils.postToStreamingOutput(clusterEndpoint, jsonPayload, timeoutMs + (long)CLIENT_SERVER_DELTA_IN_MILLISECS, headers);
    }

    private long determineTimeout(ClientRequestProperties properties, CommandType commandType) {
        Long timeoutMs;
        Long l = timeoutMs = properties == null ? null : properties.getTimeoutInMilliSec();
        if (timeoutMs == null) {
            timeoutMs = commandType == CommandType.ADMIN_COMMAND ? COMMAND_TIMEOUT_IN_MILLISECS : QUERY_TIMEOUT_IN_MILLISECS;
        }
        return timeoutMs;
    }

    private CommandType determineCommandType(String command) {
        if (command.startsWith(ADMIN_COMMANDS_PREFIX)) {
            return CommandType.ADMIN_COMMAND;
        }
        return CommandType.QUERY;
    }

    private Map<String, String> generateIngestAndCommandHeaders(ClientRequestProperties properties, String clientRequestIdPrefix, String activityTypeSuffix) throws DataServiceException, DataClientException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-ms-client-version", this.clientVersionForTracing);
        if (this.applicationNameForTracing != null) {
            headers.put("x-ms-app", this.applicationNameForTracing);
        }
        if (this.userNameForTracing != null) {
            headers.put("x-ms-user-id", this.userNameForTracing);
        }
        if (this.aadAuthenticationHelper != null) {
            headers.put("Authorization", String.format("Bearer %s", this.aadAuthenticationHelper.acquireAccessToken()));
        }
        String clientRequestId = properties != null && StringUtils.isNotBlank((CharSequence)properties.getClientRequestId()) ? properties.getClientRequestId() : String.format("%s;%s", clientRequestIdPrefix, UUID.randomUUID());
        headers.put("x-ms-client-request-id", clientRequestId);
        UUID activityId = UUID.randomUUID();
        String activityContext = String.format("%s%s/%s, ActivityId=%s, ParentId=%s, ClientRequestId=%s", JAVA_INGEST_ACTIVITY_TYPE_PREFIX, activityTypeSuffix, activityId, activityId, activityId, clientRequestId);
        headers.put("x-ms-activitycontext", activityContext);
        return headers;
    }

    private String generateCommandPayload(String database, String command, ClientRequestProperties properties, String clusterEndpoint) throws DataClientException {
        String jsonPayload;
        try {
            JSONObject json = new JSONObject().put("db", (Object)database).put("csl", (Object)command);
            if (properties != null) {
                json.put("properties", (Object)properties.toString());
            }
            jsonPayload = json.toString();
        }
        catch (JSONException e) {
            throw new DataClientException(clusterEndpoint, String.format(clusterEndpoint, "Error executing command '%s' in database '%s'. Setting up request payload failed.", command, database), (Exception)((Object)e));
        }
        return jsonPayload;
    }

    private void addCommandHeaders(Map<String, String> headers) {
        headers.put("Content-Type", "application/json");
        headers.put("Fed", "True");
    }
}

