/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import com.microsoft.azure.kusto.data.auth.ConfidentialAppTokenProviderBase;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import org.jetbrains.annotations.NotNull;

public class ApplicationKeyTokenProvider
extends ConfidentialAppTokenProviderBase {
    private final IClientSecret clientSecret;

    ApplicationKeyTokenProvider(@NotNull String clusterUrl, @NotNull String applicationClientId, @NotNull IClientSecret clientSecret, String authorityId) throws URISyntaxException {
        super(clusterUrl, applicationClientId, authorityId);
        this.clientSecret = clientSecret;
    }

    @Override
    protected void setClientApplicationBasedOnCloudInfo() throws DataClientException {
        try {
            this.clientApplication = ((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.applicationClientId, (IClientCredential)this.clientSecret).authority(this.aadAuthorityUrl)).build();
        }
        catch (MalformedURLException e) {
            throw new DataClientException(this.clusterUrl, "Error acquiring ApplicationAccessToken due to invalid Authority URL", e);
        }
    }
}

