/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.microsoft.azure.kusto.data.auth.TokenProviderBase;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public class CallbackTokenProvider
extends TokenProviderBase {
    private final Callable<String> tokenProvider;

    CallbackTokenProvider(@NotNull String clusterUrl, @NotNull Callable<String> tokenProvider) throws URISyntaxException {
        super(clusterUrl);
        this.tokenProvider = tokenProvider;
    }

    @Override
    public String acquireAccessToken() throws DataServiceException, DataClientException {
        try {
            return this.tokenProvider.call();
        }
        catch (Exception e) {
            throw new DataClientException(this.clusterUrl, e.getMessage(), e);
        }
    }
}

