/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IConfidentialClientApplication;
import com.microsoft.azure.kusto.data.auth.MsalTokenProviderBase;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public abstract class ConfidentialAppTokenProviderBase
extends MsalTokenProviderBase {
    IConfidentialClientApplication clientApplication;
    final String applicationClientId;

    ConfidentialAppTokenProviderBase(@NotNull String clusterUrl, @NotNull String applicationClientId, String authorityId) throws URISyntaxException {
        super(clusterUrl, authorityId);
        this.applicationClientId = applicationClientId;
    }

    @Override
    protected IAuthenticationResult acquireNewAccessToken() throws DataServiceException {
        IAuthenticationResult result;
        try {
            CompletableFuture future = this.clientApplication.acquireToken(ClientCredentialParameters.builder((Set)this.scopes).build());
            result = (IAuthenticationResult)future.get(20000L, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new DataServiceException(this.clusterUrl, "Error acquiring ApplicationAccessToken", e, false);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DataServiceException(this.clusterUrl, "Error acquiring ApplicationAccessToken", e, false);
        }
        if (result == null) {
            throw new DataServiceException(this.clusterUrl, "acquireNewAccessToken got 'null' authentication result", false);
        }
        return result;
    }

    @Override
    protected IAuthenticationResult acquireAccessTokenSilentlyMsal() throws MalformedURLException, InterruptedException, ExecutionException, TimeoutException {
        CompletableFuture accounts = this.clientApplication.getAccounts();
        return (IAuthenticationResult)this.clientApplication.acquireTokenSilently(this.getSilentParameters((Set)accounts.join())).get(20000L, TimeUnit.MILLISECONDS);
    }
}

