/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.identity.ManagedIdentityCredential;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.microsoft.azure.kusto.data.auth.TokenProviderBase;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ManagedIdentityTokenProvider
extends TokenProviderBase {
    private final ManagedIdentityCredential managedIdentityCredential;
    private TokenRequestContext tokenRequestContext;

    public ManagedIdentityTokenProvider(@NotNull String clusterUrl, String managedIdentityClientId) throws URISyntaxException {
        super(clusterUrl);
        ManagedIdentityCredentialBuilder builder = new ManagedIdentityCredentialBuilder();
        if (StringUtils.isNotBlank((CharSequence)managedIdentityClientId)) {
            builder = builder.clientId(managedIdentityClientId);
        }
        this.managedIdentityCredential = builder.build();
    }

    private void setRequiredMembersBasedOnCloudInfo() throws DataServiceException {
        this.tokenRequestContext = new TokenRequestContext().addScopes(new String[]{this.determineScope()});
    }

    @Override
    public String acquireAccessToken() throws DataServiceException {
        this.initializeCloudInfo();
        this.setRequiredMembersBasedOnCloudInfo();
        AccessToken accessToken = (AccessToken)this.managedIdentityCredential.getToken(this.tokenRequestContext).block();
        if (accessToken == null) {
            throw new DataServiceException(this.clusterUrl, "Couldn't get token from Azure Identity", true);
        }
        return accessToken.getToken();
    }
}

