/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IPublicClientApplication;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.azure.kusto.data.auth.MsalTokenProviderBase;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public abstract class PublicAppTokenProviderBase
extends MsalTokenProviderBase {
    protected IPublicClientApplication clientApplication;

    PublicAppTokenProviderBase(@NotNull String clusterUrl, String authorityId) throws URISyntaxException {
        super(clusterUrl, authorityId);
    }

    @Override
    protected void setClientApplicationBasedOnCloudInfo() throws DataClientException {
        try {
            this.clientApplication = ((PublicClientApplication.Builder)PublicClientApplication.builder((String)this.cloudInfo.getKustoClientAppId()).authority(this.aadAuthorityUrl)).build();
        }
        catch (MalformedURLException e) {
            throw new DataClientException(this.clusterUrl, "Error acquiring ApplicationAccessToken due to invalid Authority URL", e);
        }
    }

    @Override
    protected IAuthenticationResult acquireAccessTokenSilentlyMsal() throws MalformedURLException, InterruptedException, ExecutionException, TimeoutException {
        CompletableFuture accounts = this.clientApplication.getAccounts();
        return (IAuthenticationResult)this.clientApplication.acquireTokenSilently(this.getSilentParameters((Set)accounts.join())).get(20000L, TimeUnit.MILLISECONDS);
    }
}

