/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.microsoft.azure.kusto.data.UriUtils;
import com.microsoft.azure.kusto.data.auth.CloudInfo;
import com.microsoft.azure.kusto.data.exceptions.DataClientException;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import java.net.URISyntaxException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TokenProviderBase {
    protected static final String ERROR_ACQUIRING_APPLICATION_ACCESS_TOKEN = "Error acquiring ApplicationAccessToken";
    private static final String ERROR_INVALID_SERVICE_RESOURCE_URL = "Error determining scope due to invalid Kusto Service Resource URL";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String clusterUrl;
    protected CloudInfo cloudInfo = null;

    TokenProviderBase(@NotNull String clusterUrl) throws URISyntaxException {
        this.clusterUrl = UriUtils.setPathForUri(clusterUrl, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeCloudInfo() throws DataServiceException {
        if (this.cloudInfo != null) {
            return;
        }
        TokenProviderBase tokenProviderBase = this;
        synchronized (tokenProviderBase) {
            if (this.cloudInfo != null) {
                return;
            }
            this.cloudInfo = CloudInfo.retrieveCloudInfoForCluster(this.clusterUrl);
        }
    }

    protected String determineScope() throws DataServiceException {
        String scope;
        String resourceUrl = this.cloudInfo.getKustoServiceResourceId();
        if (this.cloudInfo.isLoginMfaRequired()) {
            resourceUrl = resourceUrl.replace(".kusto.", ".kustomfa.");
        }
        try {
            scope = UriUtils.setPathForUri(resourceUrl, ".default");
        }
        catch (URISyntaxException e) {
            throw new DataServiceException(this.clusterUrl, ERROR_INVALID_SERVICE_RESOURCE_URL, e, true);
        }
        return scope;
    }

    public abstract String acquireAccessToken() throws DataServiceException, DataClientException;
}

