/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.exceptions;

import com.microsoft.azure.kusto.data.exceptions.OneApiError;
import org.apache.http.HttpResponse;
import org.json.JSONObject;

public class DataWebException
extends Exception {
    private final HttpResponse httpResponse;
    private OneApiError apiError;

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public DataWebException(String message, HttpResponse httpResponse) {
        super(message);
        this.httpResponse = httpResponse;
        this.apiError = null;
    }

    public DataWebException(String message) {
        this(message, (HttpResponse)null);
    }

    public OneApiError getApiError() {
        if (this.apiError == null) {
            JSONObject jsonObject = new JSONObject(this.getMessage()).getJSONObject("error");
            this.apiError = new OneApiError(jsonObject.getString("code"), jsonObject.getString("message"), jsonObject.getString("@message"), jsonObject.getString("@type"), jsonObject.getJSONObject("@context"), jsonObject.getBoolean("@permanent"));
        }
        return this.apiError;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

