/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;

class InstanceDiscoveryMetadataEntry {
    @SerializedName(value="preferred_network")
    String preferredNetwork;
    @SerializedName(value="preferred_cache")
    String preferredCache;
    @SerializedName(value="aliases")
    String[] aliases;

    Set<String> getAliasesSet() {
        TreeSet<String> set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (this.aliases != null) {
            set.addAll(Arrays.asList(this.aliases));
        }
        return set;
    }

    InstanceDiscoveryMetadataEntry(String preferredNetwork, String preferredCache, String[] aliases) {
        this.preferredNetwork = preferredNetwork;
        this.preferredCache = preferredCache;
        this.aliases = aliases;
    }

    public static InstanceDiscoveryMetadataEntryBuilder builder() {
        return new InstanceDiscoveryMetadataEntryBuilder();
    }

    String getPreferredNetwork() {
        return this.preferredNetwork;
    }

    String getPreferredCache() {
        return this.preferredCache;
    }

    private String[] getAliases() {
        return this.aliases;
    }

    public static class InstanceDiscoveryMetadataEntryBuilder {
        private String preferredNetwork;
        private String preferredCache;
        private String[] aliases;

        InstanceDiscoveryMetadataEntryBuilder() {
        }

        public InstanceDiscoveryMetadataEntryBuilder preferredNetwork(String preferredNetwork) {
            this.preferredNetwork = preferredNetwork;
            return this;
        }

        public InstanceDiscoveryMetadataEntryBuilder preferredCache(String preferredCache) {
            this.preferredCache = preferredCache;
            return this;
        }

        public InstanceDiscoveryMetadataEntryBuilder aliases(String[] aliases) {
            this.aliases = aliases;
            return this;
        }

        public InstanceDiscoveryMetadataEntry build() {
            return new InstanceDiscoveryMetadataEntry(this.preferredNetwork, this.preferredCache, this.aliases);
        }

        public String toString() {
            return "InstanceDiscoveryMetadataEntry.InstanceDiscoveryMetadataEntryBuilder(preferredNetwork=" + this.preferredNetwork + ", preferredCache=" + this.preferredCache + ", aliases=" + Arrays.deepToString(this.aliases) + ")";
        }
    }
}

