// Generated by delombok at Fri Feb 07 19:13:00 UTC 2025
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import lombok.*;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import static com.microsoft.aad.msal4j.ParameterValidationUtils.validateNotNull;

/**
 * Object containing parameters for silent requests. Can be used as parameter to
 * {@link PublicClientApplication#acquireTokenSilently(SilentParameters)} or to
 * {@link ConfidentialClientApplication#acquireTokenSilently(SilentParameters)}
 */
public class SilentParameters implements IAcquireTokenParameters {
    /**
     * Scopes application is requesting access to.
     */
    @NonNull
    private Set<String> scopes;
    /**
     * Account for which you are requesting a token for.
     */
    private IAccount account;
    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims.
     */
    private ClaimsRequest claims;
    /**
     * Authority for which the application is requesting tokens from.
     */
    private String authorityUrl;
    /**
     * Force MSAL to refresh the tokens in the cache, even if there is a valid access token.
     */
    private boolean forceRefresh;
    /**
     * Adds additional headers to the token request
     */
    private Map<String, String> extraHttpHeaders;
    /**
     * Adds additional query parameters to the token request
     */
    private Map<String, String> extraQueryParameters;
    /**
     * Overrides the tenant value in the authority URL for this request
     */
    private String tenant;
    private PopParameters proofOfPossession;

    private static SilentParametersBuilder builder() {
        return new SilentParametersBuilder();
    }

    /**
     * Builder for SilentParameters
     *
     * @param scopes  scopes application is requesting access to
     * @param account {@link IAccount} for which to acquire a token for
     * @return builder object that can be used to construct SilentParameters
     */
    public static SilentParametersBuilder builder(Set<String> scopes, IAccount account) {
        validateNotNull("account", account);
        validateNotNull("scopes", scopes);
        return builder().scopes(removeEmptyScope(scopes)).account(account);
    }

    /**
     * Builder for SilentParameters
     *
     * @param scopes scopes application is requesting access to
     * @return builder object that can be used to construct SilentParameters
     * @deprecated This method was used for using cached tokens in client credentials or On-behalf-of
     * flow. Those flows will now by default attempt to use cached the cached tokens, so there is
     * no need to call acquireTokenSilently. This overload will be removed in the next major version.
     */
    public static SilentParametersBuilder builder(Set<String> scopes) {
        validateNotNull("scopes", scopes);
        return builder().scopes(removeEmptyScope(scopes));
    }

    private static Set<String> removeEmptyScope(Set<String> scopes) {
        // empty string is not a valid scope, but we currently accept it and can't remove support
        // for it yet as its a breaking change. This will be removed eventually (throwing
        // exception if empty scope is passed in).
        Set<String> updatedScopes = new HashSet<>();
        for (String scope : scopes) {
            if (!scope.equalsIgnoreCase(StringHelper.EMPTY_STRING)) {
                updatedScopes.add(scope.trim());
            }
        }
        return updatedScopes;
    }

    //This Builder class is used to override Lombok's default setter behavior for any fields defined in it
    public static class SilentParametersBuilder {
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Set<String> scopes;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private IAccount account;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private ClaimsRequest claims;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String authorityUrl;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private boolean forceRefresh;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, String> extraHttpHeaders;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private Map<String, String> extraQueryParameters;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private String tenant;
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        private PopParameters proofOfPossession;

        /**
         * Sets the PopParameters for this request, allowing the request to retrieve proof-of-possession tokens rather than bearer tokens
         *
         * For more information, see {@link PopParameters} and https://aka.ms/msal4j-pop
         *
         * @param httpMethod a valid HTTP method, such as "GET" or "POST"
         * @param uri URI to associate with the token
         * @param nonce optional nonce value for the token, can be empty or null
         */
        public SilentParametersBuilder proofOfPossession(HttpMethod httpMethod, URI uri, String nonce) {
            this.proofOfPossession = new PopParameters(httpMethod, uri, nonce);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        SilentParametersBuilder() {
        }

        /**
         * Scopes application is requesting access to.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SilentParameters.SilentParametersBuilder scopes(@NonNull final Set<String> scopes) {
            if (scopes == null) {
                throw new java.lang.NullPointerException("scopes is marked non-null but is null");
            }
            this.scopes = scopes;
            return this;
        }

        /**
         * Account for which you are requesting a token for.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SilentParameters.SilentParametersBuilder account(final IAccount account) {
            this.account = account;
            return this;
        }

        /**
         * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SilentParameters.SilentParametersBuilder claims(final ClaimsRequest claims) {
            this.claims = claims;
            return this;
        }

        /**
         * Authority for which the application is requesting tokens from.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SilentParameters.SilentParametersBuilder authorityUrl(final String authorityUrl) {
            this.authorityUrl = authorityUrl;
            return this;
        }

        /**
         * Force MSAL to refresh the tokens in the cache, even if there is a valid access token.
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SilentParameters.SilentParametersBuilder forceRefresh(final boolean forceRefresh) {
            this.forceRefresh = forceRefresh;
            return this;
        }

        /**
         * Adds additional headers to the token request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SilentParameters.SilentParametersBuilder extraHttpHeaders(final Map<String, String> extraHttpHeaders) {
            this.extraHttpHeaders = extraHttpHeaders;
            return this;
        }

        /**
         * Adds additional query parameters to the token request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SilentParameters.SilentParametersBuilder extraQueryParameters(final Map<String, String> extraQueryParameters) {
            this.extraQueryParameters = extraQueryParameters;
            return this;
        }

        /**
         * Overrides the tenant value in the authority URL for this request
         * @return {@code this}.
         */
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SilentParameters.SilentParametersBuilder tenant(final String tenant) {
            this.tenant = tenant;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public SilentParameters build() {
            return new SilentParameters(this.scopes, this.account, this.claims, this.authorityUrl, this.forceRefresh, this.extraHttpHeaders, this.extraQueryParameters, this.tenant, this.proofOfPossession);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "SilentParameters.SilentParametersBuilder(scopes=" + this.scopes + ", account=" + this.account + ", claims=" + this.claims + ", authorityUrl=" + this.authorityUrl + ", forceRefresh=" + this.forceRefresh + ", extraHttpHeaders=" + this.extraHttpHeaders + ", extraQueryParameters=" + this.extraQueryParameters + ", tenant=" + this.tenant + ", proofOfPossession=" + this.proofOfPossession + ")";
        }
    }

    /**
     * Scopes application is requesting access to.
     */
    @NonNull
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Set<String> scopes() {
        return this.scopes;
    }

    /**
     * Account for which you are requesting a token for.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IAccount account() {
        return this.account;
    }

    /**
     * Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ClaimsRequest claims() {
        return this.claims;
    }

    /**
     * Authority for which the application is requesting tokens from.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String authorityUrl() {
        return this.authorityUrl;
    }

    /**
     * Force MSAL to refresh the tokens in the cache, even if there is a valid access token.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean forceRefresh() {
        return this.forceRefresh;
    }

    /**
     * Adds additional headers to the token request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    /**
     * Adds additional query parameters to the token request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, String> extraQueryParameters() {
        return this.extraQueryParameters;
    }

    /**
     * Overrides the tenant value in the authority URL for this request
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String tenant() {
        return this.tenant;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public PopParameters proofOfPossession() {
        return this.proofOfPossession;
    }

    /**
     * Creates a new {@code SilentParameters} instance.
     *
     * @param scopes Scopes application is requesting access to.
     * @param account Account for which you are requesting a token for.
     * @param claims Claims to be requested through the OIDC claims request parameter, allowing requests for standard and custom claims.
     * @param authorityUrl Authority for which the application is requesting tokens from.
     * @param forceRefresh Force MSAL to refresh the tokens in the cache, even if there is a valid access token.
     * @param extraHttpHeaders Adds additional headers to the token request
     * @param extraQueryParameters Adds additional query parameters to the token request
     * @param tenant Overrides the tenant value in the authority URL for this request
     * @param proofOfPossession
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private SilentParameters(@NonNull final Set<String> scopes, final IAccount account, final ClaimsRequest claims, final String authorityUrl, final boolean forceRefresh, final Map<String, String> extraHttpHeaders, final Map<String, String> extraQueryParameters, final String tenant, final PopParameters proofOfPossession) {
        if (scopes == null) {
            throw new java.lang.NullPointerException("scopes is marked non-null but is null");
        }
        this.scopes = scopes;
        this.account = account;
        this.claims = claims;
        this.authorityUrl = authorityUrl;
        this.forceRefresh = forceRefresh;
        this.extraHttpHeaders = extraHttpHeaders;
        this.extraQueryParameters = extraQueryParameters;
        this.tenant = tenant;
        this.proofOfPossession = proofOfPossession;
    }
}
