// Generated by delombok at Fri Feb 07 19:13:00 UTC 2025
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
package com.microsoft.aad.msal4j;

import java.net.MalformedURLException;
import java.net.URL;

class SilentRequest extends MsalRequest {
    private SilentParameters parameters;
    private IUserAssertion assertion;
    private Authority requestAuthority;

    SilentRequest(SilentParameters parameters, AbstractApplicationBase application, RequestContext requestContext, IUserAssertion assertion) throws MalformedURLException {
        super(application, null, requestContext);
        this.parameters = parameters;
        this.assertion = assertion;
        this.requestAuthority = StringHelper.isBlank(parameters.authorityUrl()) ? application.authenticationAuthority : Authority.createAuthority(new URL(Authority.enforceTrailingSlash(parameters.authorityUrl())));
        if (parameters.forceRefresh()) {
            application.serviceBundle().getServerSideTelemetry().getCurrentRequest().cacheInfo(CacheRefreshReason.FORCE_REFRESH);
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SilentParameters parameters() {
        return this.parameters;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public IUserAssertion assertion() {
        return this.assertion;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Authority requestAuthority() {
        return this.requestAuthority;
    }
}
