/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;

public class FileUploadStatusParser {
    private static final String CORRELATION_ID_TAG = "correlationId";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="correlationId")
    private String correlationId = null;
    private static final String IS_SUCCESS_TAG = "isSuccess";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="isSuccess")
    private Boolean isSuccess = null;
    private static final String STATUS_CODE_TAG = "statusCode";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="statusCode")
    private Integer statusCode = null;
    private static final String STATUS_DESCRIPTION_TAG = "statusDescription";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="statusDescription")
    private String statusDescription = null;

    public FileUploadStatusParser(String correlationId, Boolean isSuccess, Integer statusCode, String statusDescription) throws IllegalArgumentException {
        this.setCorrelationId(correlationId);
        this.updateStatus(isSuccess, statusCode, statusDescription);
    }

    private void updateStatus(Boolean isSuccess, Integer statusCode, String statusDescription) throws IllegalArgumentException {
        ParserUtility.validateObject(isSuccess);
        ParserUtility.validateObject(statusCode);
        ParserUtility.validateStringUTF8(statusDescription);
        this.isSuccess = isSuccess;
        this.statusCode = statusCode;
        this.statusDescription = statusDescription;
    }

    public String toJson() {
        Gson gson = new GsonBuilder().disableHtmlEscaping().serializeNulls().create();
        return gson.toJson((Object)this);
    }

    private void setCorrelationId(String correlationId) {
        ParserUtility.validateStringUTF8(correlationId);
        this.correlationId = correlationId;
    }
}

