/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TwinMetadata {
    private static final String DATEFORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String TIMEZONE = "UTC";
    @SerializedName(value="$lastUpdated")
    private String lastUpdated;
    @SerializedName(value="$lastUpdatedVersion")
    private Integer lastUpdatedVersion;

    protected TwinMetadata() {
        this.update();
        this.lastUpdatedVersion = null;
    }

    protected TwinMetadata(Integer lastUpdatedVersion) {
        this.update();
        this.lastUpdatedVersion = lastUpdatedVersion;
    }

    protected TwinMetadata(Integer lastUpdatedVersion, String lastUpdated) {
        this.lastUpdated = lastUpdated;
        this.lastUpdatedVersion = lastUpdatedVersion;
    }

    protected synchronized boolean update(String lastUpdated, Integer lastUpdatedVersion) {
        boolean updated = !this.lastUpdated.equals(lastUpdated) ? true : (this.lastUpdatedVersion == null ? lastUpdatedVersion != null : !this.lastUpdatedVersion.equals(lastUpdatedVersion));
        this.lastUpdated = lastUpdated;
        this.lastUpdatedVersion = lastUpdatedVersion;
        return updated;
    }

    protected synchronized void update(int lastUpdatedVersion) {
        this.update();
        this.lastUpdatedVersion = lastUpdatedVersion;
    }

    protected synchronized void update() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATEFORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone(TIMEZONE));
        this.lastUpdated = dateFormat.format(new Date());
    }

    protected synchronized Integer getLastUpdateVersion() {
        return this.lastUpdatedVersion;
    }

    protected synchronized String getLastUpdate() {
        return this.lastUpdated;
    }

    protected JsonElement toJsonElement() {
        Gson gson = new GsonBuilder().create();
        return gson.toJsonTree((Object)this);
    }
}

