/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;
import java.util.Map;

public class MethodParser {
    @Expose(serialize=false, deserialize=false)
    private Operation operation = Operation.none;
    private static final String METHOD_NAME_TAG = "methodName";
    @Expose(serialize=true, deserialize=false)
    @SerializedName(value="methodName")
    private String name = null;
    private static final String RESPONSE_TIMEOUT_IN_SECONDS_TAG = "responseTimeoutInSeconds";
    @Expose(serialize=true, deserialize=false)
    @SerializedName(value="responseTimeoutInSeconds")
    private Long responseTimeout = null;
    private static final String CONNECT_TIMEOUT_IN_SECONDS_TAG = "connectTimeoutInSeconds";
    @Expose(serialize=true, deserialize=false)
    @SerializedName(value="connectTimeoutInSeconds")
    private Long connectTimeout = null;
    private static final String STATUS_TAG = "status";
    @Expose(serialize=false, deserialize=true)
    @SerializedName(value="status")
    private Integer status = null;
    private static final String PAYLOAD_TAG = "payload";
    @SerializedName(value="payload")
    private Object payload = null;

    public MethodParser() {
    }

    public MethodParser(String name, Long responseTimeout, Long connectTimeout, Object payload) throws IllegalArgumentException {
        this();
        this.validateKey(name);
        if (responseTimeout != null) {
            this.validateTimeout(responseTimeout);
        }
        if (connectTimeout != null) {
            this.validateTimeout(connectTimeout);
        }
        this.name = name;
        this.responseTimeout = responseTimeout;
        this.connectTimeout = connectTimeout;
        this.payload = payload;
        this.operation = Operation.invoke;
    }

    public MethodParser(Object payload) {
        this();
        this.payload = payload;
        this.operation = Operation.payload;
    }

    public synchronized void fromJson(String json) throws IllegalArgumentException {
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("Invalid json");
        }
        Gson gson = new GsonBuilder().serializeNulls().create();
        if (json.contains(METHOD_NAME_TAG)) {
            MethodParser newMethodParser;
            if (json.contains(STATUS_TAG)) {
                throw new IllegalArgumentException("Invoke method name and Status reported in the same json");
            }
            try {
                newMethodParser = (MethodParser)gson.fromJson(json, MethodParser.class);
            }
            catch (JsonSyntaxException malformed) {
                throw new IllegalArgumentException("Malformed json:" + (Object)((Object)malformed));
            }
            this.name = newMethodParser.name;
            this.responseTimeout = newMethodParser.responseTimeout;
            this.connectTimeout = newMethodParser.connectTimeout;
            this.status = null;
            this.payload = newMethodParser.payload;
            this.operation = Operation.invoke;
        } else if (json.contains(STATUS_TAG)) {
            MethodParser newMethodParser;
            try {
                newMethodParser = (MethodParser)gson.fromJson(json, MethodParser.class);
            }
            catch (JsonSyntaxException malformed) {
                throw new IllegalArgumentException("Malformed json:" + (Object)((Object)malformed));
            }
            this.name = null;
            this.responseTimeout = null;
            this.connectTimeout = null;
            this.status = newMethodParser.status;
            this.payload = newMethodParser.payload;
            this.operation = Operation.response;
        } else {
            try {
                this.name = null;
                this.responseTimeout = null;
                this.connectTimeout = null;
                this.status = null;
                this.payload = gson.fromJson(json, Object.class);
                this.operation = Operation.payload;
            }
            catch (JsonSyntaxException malformed) {
                throw new IllegalArgumentException("Malformed json:" + (Object)((Object)malformed));
            }
        }
    }

    public Integer getStatus() throws IllegalArgumentException {
        if (this.operation != Operation.response) {
            throw new IllegalArgumentException("No response to report status");
        }
        return this.status;
    }

    public Object getPayload() {
        return this.payload;
    }

    public String toJson() throws IllegalArgumentException {
        return this.toJsonElement().toString();
    }

    public JsonElement toJsonElement() throws IllegalArgumentException {
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().serializeNulls().create();
        JsonObject jsonProperty = new JsonObject();
        switch (this.operation) {
            case invoke: {
                if (this.name == null || this.name.isEmpty()) {
                    throw new IllegalArgumentException("cannot invoke method with null name");
                }
                jsonProperty.addProperty(METHOD_NAME_TAG, this.name);
                if (this.responseTimeout != null) {
                    jsonProperty.addProperty(RESPONSE_TIMEOUT_IN_SECONDS_TAG, (Number)this.responseTimeout);
                }
                if (this.connectTimeout != null) {
                    jsonProperty.addProperty(CONNECT_TIMEOUT_IN_SECONDS_TAG, (Number)this.connectTimeout);
                }
                if (this.payload instanceof Map) {
                    jsonProperty.add(PAYLOAD_TAG, ParserUtility.mapToJsonElement((Map)this.payload));
                } else {
                    jsonProperty.add(PAYLOAD_TAG, gson.toJsonTree(this.payload));
                }
                return jsonProperty;
            }
            case response: {
                jsonProperty.addProperty(STATUS_TAG, (Number)this.status);
                if (this.payload instanceof Map) {
                    jsonProperty.add(PAYLOAD_TAG, ParserUtility.mapToJsonElement((Map)this.payload));
                } else {
                    jsonProperty.add(PAYLOAD_TAG, gson.toJsonTree(this.payload));
                }
                return jsonProperty;
            }
            case payload: {
                if (this.payload instanceof Map) {
                    return ParserUtility.mapToJsonElement((Map)this.payload);
                }
                return gson.toJsonTree(this.payload);
            }
        }
        throw new IllegalArgumentException("There is no content to parser");
    }

    private void validateKey(String key) throws IllegalArgumentException {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty");
        }
        if (key.length() > 128) {
            throw new IllegalArgumentException("Key cannot be longer than 128 characters");
        }
        if (key.contains("$") || key.contains(".") || key.contains(" ")) {
            throw new IllegalArgumentException("Key cannot contain '$', '.', or space");
        }
    }

    private void validateTimeout(Long timeout) throws IllegalArgumentException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
    }

    protected static enum Operation {
        invoke,
        response,
        payload,
        none;

    }
}

