/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;
import com.microsoft.azure.sdk.iot.deps.serializer.TwinChangedCallback;
import com.microsoft.azure.sdk.iot.deps.serializer.TwinMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TwinProperty {
    private static final String VERSION_TAG = "$version";
    private static final String METADATA_TAG = "$metadata";
    private static final String LAST_UPDATE_TAG = "$lastUpdated";
    private static final String LAST_UPDATE_VERSION_TAG = "$lastUpdatedVersion";
    private static final int MAX_PROPERTY_LEVEL = 5;
    private static final int MAX_METADATA_LEVEL = 7;
    private Object lock = new Object();
    private ConcurrentMap<String, Property> property = new ConcurrentHashMap<String, Property>();
    private Integer version = null;
    private Boolean reportMetadata = false;

    protected TwinProperty() {
    }

    protected void enableMetadata() {
        this.reportMetadata = true;
    }

    protected Boolean addProperty(String key, Object value, Integer propertyVersion) throws IllegalArgumentException {
        Boolean change = false;
        if (key == null) {
            throw new IllegalArgumentException("Property key shall not be null");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Property key shall not be empty");
        }
        if (key.length() > 128) {
            throw new IllegalArgumentException("Property key is too big for json");
        }
        if (key.contains(".") || key.contains(" ") || key.contains("$")) {
            throw new IllegalArgumentException("Property key contains illegal character");
        }
        if (value == null) {
            if (this.property.containsKey(key)) {
                this.property.remove(key);
            }
            change = true;
        } else {
            if (!this.property.containsKey(key) || !((Property)this.property.get(key)).value.equals(value) || this.reportMetadata.booleanValue()) {
                change = true;
            }
            this.property.put(key, new Property(value, propertyVersion));
        }
        return change;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonElement update(Map<String, Object> property) {
        JsonElement updatedJsonElement;
        TwinProperty updated = new TwinProperty();
        Object object = this.lock;
        synchronized (object) {
            if (property != null) {
                for (Map.Entry<String, Object> entry : property.entrySet()) {
                    if (!this.addProperty(entry.getKey(), entry.getValue(), null).booleanValue()) continue;
                    updated.property.put(entry.getKey(), new Property(entry.getValue(), null));
                }
                updatedJsonElement = updated.size() > 0 ? updated.toJsonElement() : null;
            } else {
                updatedJsonElement = null;
            }
        }
        return updatedJsonElement;
    }

    protected void validate(Map<String, Object> property) throws IllegalArgumentException {
        if (property == null) {
            throw new IllegalArgumentException("property cannot be null");
        }
        for (Map.Entry<String, Object> entry : property.entrySet()) {
            if (entry.getKey().equals(METADATA_TAG)) {
                if (!(entry.getValue() instanceof Map)) continue;
                ParserUtility.validateMap((Map)entry.getValue(), 7, true);
                continue;
            }
            if (entry.getKey().equals(VERSION_TAG) || !(entry.getValue() instanceof Map)) continue;
            ParserUtility.validateMap((Map)entry.getValue(), 5, false);
        }
    }

    protected Integer getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TwinMetadata getMetadata(String key) {
        TwinMetadata twinMetadata = null;
        Object object = this.lock;
        synchronized (object) {
            twinMetadata = this.property.containsKey(key) ? ((Property)this.property.get(key)).metadata : null;
        }
        return twinMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> getPropertyMap() {
        HashMap<String, Object> propertyMap = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.property.isEmpty()) {
                propertyMap = null;
            } else {
                propertyMap = new HashMap<String, Object>();
                for (Map.Entry entry : this.property.entrySet()) {
                    Object value = ((Property)entry.getValue()).value;
                    if (value == null) {
                        propertyMap.put((String)entry.getKey(), null);
                        continue;
                    }
                    propertyMap.put((String)entry.getKey(), value);
                }
            }
        }
        return propertyMap;
    }

    protected int size() {
        return this.property.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object get(String key) {
        Object result = null;
        Object object = this.lock;
        synchronized (object) {
            result = this.property.containsKey(key) ? ((Property)this.property.get(key)).value : null;
        }
        return result;
    }

    protected String toJson() {
        return this.toJsonElement().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonElement toJsonElement() {
        HashMap<String, Object> diffMap = new HashMap<String, Object>();
        HashMap metadata = new HashMap();
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry entry : this.property.entrySet()) {
                diffMap.put((String)entry.getKey(), ((Property)entry.getValue()).value);
                metadata.put(entry.getKey(), ((Property)entry.getValue()).metadata.toJsonElement());
            }
        }
        if (this.reportMetadata.booleanValue()) {
            diffMap.put(METADATA_TAG, metadata);
        }
        if (this.version != null) {
            diffMap.put(VERSION_TAG, this.version);
        }
        return ParserUtility.mapToJsonElement(diffMap);
    }

    protected void update(Map<String, Object> jsonTree, TwinChangedCallback onCallback) throws IllegalArgumentException {
        Map<Object, Object> diffField = new HashMap();
        Map<Object, Object> diffMetadata = new HashMap();
        try {
            this.updateVersion(jsonTree);
            diffField = this.updateFields(jsonTree);
            diffMetadata = this.updateMetadata(jsonTree);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Malformed Json:" + e);
        }
        if (this.reportMetadata.booleanValue()) {
            for (Map.Entry<Object, Object> entry : diffMetadata.entrySet()) {
                Property val = (Property)this.property.get(entry.getKey());
                if (val == null) {
                    diffField.put(entry.getKey(), null);
                    continue;
                }
                diffField.put(entry.getKey(), val.value);
            }
        }
        if (diffField.size() != 0 && onCallback != null) {
            onCallback.execute(diffField);
        }
    }

    protected void update(String json, TwinChangedCallback onCallback) throws IllegalArgumentException {
        Map newValues;
        try {
            Gson gson = new GsonBuilder().create();
            newValues = (Map)gson.fromJson(json, Map.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Malformed Json:" + e);
        }
        this.update(newValues, onCallback);
    }

    private void updateVersion(Map<String, Object> jsonTree) {
        for (Map.Entry<String, Object> entry : jsonTree.entrySet()) {
            if (!entry.getKey().equals(VERSION_TAG)) continue;
            this.version = new Integer((int)((Double)entry.getValue()).doubleValue());
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> updateMetadata(Map<String, Object> jsonTree) {
        HashMap<String, Object> diff = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : jsonTree.entrySet()) {
            if (!entry.getKey().equals(METADATA_TAG)) continue;
            Map metadataTree = (Map)entry.getValue();
            for (Map.Entry item : metadataTree.entrySet()) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.property.containsKey(item.getKey())) {
                        Map itemTree = (Map)item.getValue();
                        String lastUpdated = null;
                        Integer lastUpdatedVersion = null;
                        for (Map.Entry metadataItem : itemTree.entrySet()) {
                            if (((String)metadataItem.getKey()).equals(LAST_UPDATE_TAG)) {
                                lastUpdated = metadataItem.getValue().toString();
                                continue;
                            }
                            if (!((String)metadataItem.getKey()).equals(LAST_UPDATE_VERSION_TAG)) continue;
                            lastUpdatedVersion = (int)((Double)metadataItem.getValue()).doubleValue();
                        }
                        if (((Property)this.property.get(item.getKey())).metadata.update(lastUpdated, lastUpdatedVersion)) {
                            diff.put((String)item.getKey(), item.getValue());
                        }
                    }
                }
            }
        }
        return diff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> updateFields(Map<String, Object> jsonTree) throws IllegalArgumentException {
        HashMap<String, Object> diff = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : jsonTree.entrySet()) {
            if (entry.getKey().isEmpty()) {
                throw new IllegalArgumentException("Invalid Key on Json");
            }
            if (entry.getKey().contains("$")) continue;
            Object object = this.lock;
            synchronized (object) {
                if (this.property.containsKey(entry.getKey())) {
                    if (entry.getValue() == null) {
                        this.property.remove(entry.getKey());
                        diff.put(entry.getKey(), null);
                    } else if (!((Property)this.property.get(entry.getKey())).value.equals(entry.getValue())) {
                        this.property.put(entry.getKey(), new Property(entry.getValue(), null));
                        diff.put(entry.getKey(), entry.getValue());
                    }
                } else if (entry.getValue() != null) {
                    this.property.put(entry.getKey(), new Property(entry.getValue(), null));
                    diff.put(entry.getKey(), entry.getValue());
                }
            }
        }
        return diff;
    }

    private class Property {
        private Object value;
        private TwinMetadata metadata;

        private Property(Object val, Integer propertyVersion) {
            this.value = val;
            this.metadata = new TwinMetadata(propertyVersion);
        }
    }
}

