/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.ws.impl;

import com.microsoft.azure.sdk.iot.deps.util.Base64;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Scanner;

public class WebSocketUpgrade {
    public static final String RFC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private final char _colon = (char)58;
    private final char _slash = (char)47;
    private String _host = "";
    private String _path = "";
    private String _port = "";
    private String _protocol = "";
    private String _webSocketKey = "";
    private Map<String, String> _additionalHeaders = null;
    private boolean _certAvailability = false;

    public WebSocketUpgrade(String hostName, String webSocketPath, int webSocketPort, String webSocketProtocol, Map<String, String> additionalHeaders) {
        this.setHost(hostName);
        this.setPath(webSocketPath);
        this.setPort(webSocketPort);
        this.setProtocol(webSocketProtocol);
        this.setAdditionalHeaders(additionalHeaders);
    }

    public void setHost(String host) {
        this._host = host;
    }

    public void setPort(int port) {
        this._port = "";
        if (port != 0) {
            this._port = String.valueOf(port);
        }
    }

    public void setPath(String path) {
        this._path = path;
        if (!this._path.isEmpty() && this._path.charAt(0) != this._slash) {
            this._path = this._slash + this._path;
        }
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public void setAdditionalHeaders(Map<String, String> additionalHeaders) {
        this._additionalHeaders = additionalHeaders;
    }

    public void clearAdditionalHeaders() {
        this._additionalHeaders.clear();
    }

    public void setClientCertAvailable() {
        this._certAvailability = true;
    }

    private String createWebSocketKey() {
        byte[] key = new byte[16];
        for (int i = 0; i < 16; ++i) {
            key[i] = (byte)(Math.random() * 256.0);
        }
        return Base64.encodeBase64StringLocal(key).trim();
    }

    public String createUpgradeRequest() {
        if (this._host.isEmpty()) {
            throw new InvalidParameterException("host header has no value");
        }
        if (this._protocol.isEmpty()) {
            throw new InvalidParameterException("protocol header has no value");
        }
        this._webSocketKey = this.createWebSocketKey();
        String _endOfLine = "\r\n";
        StringBuilder stringBuilder = new StringBuilder().append("GET https://").append(this._host).append(this._path).append("?").append("iothub-no-client-cert=").append(!this._certAvailability).append(" HTTP/1.1").append(_endOfLine).append("Connection: Upgrade,Keep-Alive").append(_endOfLine).append("Upgrade: websocket").append(_endOfLine).append("Sec-WebSocket-Version: 13").append(_endOfLine).append("Sec-WebSocket-Key: ").append(this._webSocketKey).append(_endOfLine).append("Sec-WebSocket-Protocol: ").append(this._protocol).append(_endOfLine).append("Host: ").append(this._host).append(_endOfLine);
        if (this._additionalHeaders != null) {
            for (Map.Entry<String, String> entry : this._additionalHeaders.entrySet()) {
                stringBuilder.append(entry.getKey() + ": " + entry.getValue()).append(_endOfLine);
            }
        }
        stringBuilder.append(_endOfLine);
        return stringBuilder.toString();
    }

    public Boolean validateUpgradeReply(byte[] responseBytes) {
        String httpString = new String(responseBytes, StandardCharsets.UTF_8);
        Boolean isStatusLineOk = false;
        Boolean isUpgradeHeaderOk = false;
        Boolean isConnectionHeaderOk = false;
        Boolean isProtocolHeaderOk = false;
        Boolean isAcceptHeaderOk = false;
        Scanner scanner = new Scanner(httpString);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.toLowerCase().contains("http/1.1") && line.contains("101") && line.toLowerCase().contains("switching protocols")) {
                isStatusLineOk = true;
                continue;
            }
            if (line.toLowerCase().contains("upgrade") && line.toLowerCase().contains("websocket")) {
                isUpgradeHeaderOk = true;
                continue;
            }
            if (line.toLowerCase().contains("connection") && line.toLowerCase().contains("upgrade")) {
                isConnectionHeaderOk = true;
                continue;
            }
            if (line.toLowerCase().contains("sec-websocket-protocol") && line.toLowerCase().contains(this._protocol.toLowerCase())) {
                isProtocolHeaderOk = true;
                continue;
            }
            if (!line.toLowerCase().contains("sec-websocket-accept")) continue;
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                break;
            }
            String expectedKey = Base64.encodeBase64StringLocal(messageDigest.digest((this._webSocketKey + RFC_GUID).getBytes())).trim();
            if (!line.contains(expectedKey)) continue;
            isAcceptHeaderOk = true;
        }
        scanner.close();
        if (isStatusLineOk.booleanValue() && isUpgradeHeaderOk.booleanValue() && isConnectionHeaderOk.booleanValue() && isProtocolHeaderOk.booleanValue() && isAcceptHeaderOk.booleanValue()) {
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WebSocketUpgrade [host=").append(this._host).append(", path=").append(this._path).append(", port=").append(this._port).append(", protocol=").append(this._protocol).append(", webSocketKey=").append(this._webSocketKey);
        if (this._additionalHeaders != null && !this._additionalHeaders.isEmpty()) {
            builder.append(", additionalHeaders=");
            for (Map.Entry<String, String> entry : this._additionalHeaders.entrySet()) {
                builder.append(entry.getKey() + ":" + entry.getValue()).append(", ");
            }
            int lastIndex = builder.lastIndexOf(", ");
            builder.delete(lastIndex, lastIndex + 2);
        }
        builder.append("]");
        return builder.toString();
    }
}

