/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.serializer;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.deps.serializer.AuthenticationParser;
import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;
import java.util.Date;

public class DeviceParser {
    private static final String E_TAG_NAME = "etag";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="etag")
    private String eTag;
    private static final String DEVICE_ID_NAME = "deviceId";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="deviceId")
    private String deviceId;
    private static final String GENERATION_ID_NAME = "generationId";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="generationId")
    private String generationId;
    private static final String STATUS_NAME = "status";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="status")
    private String status;
    private static final String STATUS_REASON = "statusReason";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="statusReason")
    private String statusReason;
    private static final String STATUS_UPDATED_TIME_NAME = "statusUpdatedTime";
    @Expose(serialize=true, deserialize=false)
    @SerializedName(value="statusUpdatedTime")
    private String statusUpdatedTimeString;
    private transient Date statusUpdatedTime;
    private static final String CONNECTION_STATE_NAME = "connectionState";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="connectionState")
    private String connectionState;
    private static final String CONNECTION_STATE_UPDATED_TIME_NAME = "connectionStateUpdatedTime";
    @Expose(serialize=true, deserialize=false)
    @SerializedName(value="connectionStateUpdatedTime")
    private String connectionStateUpdatedTimeString;
    private transient Date connectionStateUpdatedTime;
    private static final String LAST_ACTIVITY_TIME_NAME = "lastActivityTime";
    @Expose(serialize=true, deserialize=false)
    @SerializedName(value="lastActivityTime")
    private String lastActivityTimeString;
    private transient Date lastActivityTime;
    private static final String CLOUD_TO_MESSAGE_COUNT_NAME = "cloudToDeviceMessageCount";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="cloudToDeviceMessageCount")
    private long cloudToDeviceMessageCount;
    private static final String AUTHENTICATION_NAME = "authentication";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="authentication")
    private AuthenticationParser authenticationParser;
    private transient Gson gson = new Gson();

    public String toJson() {
        if (this.statusUpdatedTime != null) {
            this.statusUpdatedTimeString = ParserUtility.getDateStringFromDate(this.statusUpdatedTime);
        }
        if (this.connectionStateUpdatedTime != null) {
            this.connectionStateUpdatedTimeString = ParserUtility.getDateStringFromDate(this.connectionStateUpdatedTime);
        }
        if (this.lastActivityTime != null) {
            this.lastActivityTimeString = ParserUtility.getDateStringFromDate(this.lastActivityTime);
        }
        return this.gson.toJson((Object)this);
    }

    public DeviceParser() {
    }

    public DeviceParser(String json) {
        DeviceParser deviceParser;
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("The provided json cannot be null or empty");
        }
        try {
            deviceParser = (DeviceParser)this.gson.fromJson(json, DeviceParser.class);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException("The provided json could not be parsed");
        }
        if (deviceParser.deviceId == null || deviceParser.deviceId.isEmpty()) {
            throw new IllegalArgumentException("The provided json must contain the field for deviceId and its value may not be empty");
        }
        if (deviceParser.authenticationParser == null) {
            throw new IllegalArgumentException("The provided json must contain the field for authentication and its value may not be empty");
        }
        this.authenticationParser = deviceParser.authenticationParser;
        this.connectionState = deviceParser.connectionState;
        this.deviceId = deviceParser.deviceId;
        this.statusReason = deviceParser.statusReason;
        this.cloudToDeviceMessageCount = deviceParser.cloudToDeviceMessageCount;
        this.connectionState = deviceParser.connectionState;
        this.generationId = deviceParser.generationId;
        this.eTag = deviceParser.eTag;
        this.status = deviceParser.status;
        if (deviceParser.lastActivityTimeString != null) {
            this.lastActivityTimeString = deviceParser.lastActivityTimeString;
            this.lastActivityTime = ParserUtility.getDateTimeUtc(deviceParser.lastActivityTimeString);
        }
        if (deviceParser.connectionStateUpdatedTimeString != null) {
            this.connectionStateUpdatedTimeString = deviceParser.connectionStateUpdatedTimeString;
            this.connectionStateUpdatedTime = ParserUtility.getDateTimeUtc(deviceParser.connectionStateUpdatedTimeString);
        }
        if (deviceParser.statusUpdatedTimeString != null) {
            this.statusUpdatedTimeString = deviceParser.statusUpdatedTimeString;
            this.statusUpdatedTime = ParserUtility.getDateTimeUtc(deviceParser.statusUpdatedTimeString);
        }
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) throws IllegalArgumentException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("DeviceId cannot not be null");
        }
        this.deviceId = deviceId;
    }

    public AuthenticationParser getAuthenticationParser() {
        return this.authenticationParser;
    }

    public void setAuthenticationParser(AuthenticationParser authenticationParser) throws IllegalArgumentException {
        if (authenticationParser == null) {
            throw new IllegalArgumentException("Authentication cannot not be null");
        }
        this.authenticationParser = authenticationParser;
    }

    public String geteTag() {
        return this.eTag;
    }

    public void seteTag(String eTag) {
        this.eTag = eTag;
    }

    public String getGenerationId() {
        return this.generationId;
    }

    public void setGenerationId(String generationId) {
        this.generationId = generationId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public Date getStatusUpdatedTime() {
        return this.statusUpdatedTime;
    }

    public void setStatusUpdatedTime(Date statusUpdatedTime) {
        this.statusUpdatedTime = statusUpdatedTime;
        this.statusUpdatedTimeString = statusUpdatedTime == null ? null : ParserUtility.getDateStringFromDate(statusUpdatedTime);
    }

    public String getConnectionState() {
        return this.connectionState;
    }

    public void setConnectionState(String connectionState) {
        this.connectionState = connectionState;
    }

    public Date getConnectionStateUpdatedTime() {
        return this.connectionStateUpdatedTime;
    }

    public void setConnectionStateUpdatedTime(Date connectionStateUpdatedTime) {
        this.connectionStateUpdatedTime = connectionStateUpdatedTime;
        this.connectionStateUpdatedTimeString = connectionStateUpdatedTime == null ? null : ParserUtility.getDateStringFromDate(connectionStateUpdatedTime);
    }

    public Date getLastActivityTime() {
        return this.lastActivityTime;
    }

    public void setLastActivityTime(Date lastActivityTime) {
        this.lastActivityTime = lastActivityTime;
        this.lastActivityTimeString = lastActivityTime == null ? null : ParserUtility.getDateStringFromDate(lastActivityTime);
    }

    public long getCloudToDeviceMessageCount() {
        return this.cloudToDeviceMessageCount;
    }

    public void setCloudToDeviceMessageCount(long cloudToDeviceMessageCount) {
        this.cloudToDeviceMessageCount = cloudToDeviceMessageCount;
    }
}

