/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.twin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.deps.twin.ConfigurationInfo;
import com.microsoft.azure.sdk.iot.deps.twin.RegisterManager;
import com.microsoft.azure.sdk.iot.deps.twin.TwinCollection;
import com.microsoft.azure.sdk.iot.deps.twin.TwinProperties;
import com.microsoft.azure.sdk.iot.deps.util.Tools;
import java.util.Map;

public class TwinState
extends RegisterManager {
    private static final String TAGS_TAG = "tags";
    @Expose(serialize=false, deserialize=true)
    @SerializedName(value="tags")
    private TwinCollection tags;
    private static final String PROPERTIES_TAG = "properties";
    @Expose(serialize=false, deserialize=true)
    @SerializedName(value="properties")
    private TwinProperties properties;
    private static final String CONFIGURATION_TAG = "configurations";
    @Expose(serialize=false, deserialize=true)
    @SerializedName(value="configurations")
    private Map<String, ConfigurationInfo> configurations;

    public TwinState(TwinCollection tags, TwinCollection desiredProperty, TwinCollection reportedProperty) {
        if (tags != null) {
            this.tags = TwinCollection.createFromRawCollection(tags);
        }
        if (desiredProperty != null || reportedProperty != null) {
            this.properties = new TwinProperties(desiredProperty, reportedProperty);
        }
    }

    public JsonElement toJsonElement() {
        Gson gson = new GsonBuilder().disableHtmlEscaping().serializeNulls().create();
        JsonObject json = gson.toJsonTree((Object)this).getAsJsonObject();
        if (json != null && this.properties != null) {
            json.getAsJsonObject().add(PROPERTIES_TAG, this.properties.toJsonElement());
        }
        return json;
    }

    public TwinCollection getTags() {
        return new TwinCollection(this.tags);
    }

    public TwinCollection getDesiredProperty() {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getDesired();
    }

    public TwinCollection getReportedProperty() {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getReported();
    }

    public Map<String, ConfigurationInfo> getConfigurations() {
        return this.configurations;
    }

    public String toString() {
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().disableHtmlEscaping().create();
        JsonObject jsonObject = gson.toJsonTree((Object)this).getAsJsonObject();
        if (this.tags != null) {
            jsonObject.add(TAGS_TAG, this.tags.toJsonElementWithMetadata());
        }
        if (this.properties != null) {
            jsonObject.add(PROPERTIES_TAG, this.properties.toJsonElementWithMetadata());
        }
        return jsonObject.toString();
    }

    public static TwinState createFromTwinJson(String json) {
        if (Tools.isNullOrEmpty(json).booleanValue()) {
            throw new IllegalArgumentException("JSON with result is null or empty");
        }
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().disableHtmlEscaping().create();
        TwinState result = (TwinState)gson.fromJson(json, TwinState.class);
        result.tags = new TwinCollection(result.getTags());
        if (result.properties != null) {
            result.properties = new TwinProperties(result.properties.getDesired(), result.properties.getReported());
        }
        return result;
    }

    public static TwinState createFromDesiredPropertyJson(String json) {
        if (Tools.isNullOrEmpty(json).booleanValue()) {
            throw new IllegalArgumentException("JSON with result is null or empty");
        }
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().disableHtmlEscaping().create();
        TwinCollection result = (TwinCollection)gson.fromJson(json, TwinCollection.class);
        return new TwinState(null, result, null);
    }

    public static TwinState createFromReportedPropertyJson(String json) {
        if (Tools.isNullOrEmpty(json).booleanValue()) {
            throw new IllegalArgumentException("JSON with result is null or empty");
        }
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().disableHtmlEscaping().create();
        TwinCollection result = (TwinCollection)gson.fromJson(json, TwinCollection.class);
        return new TwinState(null, null, result);
    }

    public static TwinState createFromPropertiesJson(String json) {
        if (Tools.isNullOrEmpty(json).booleanValue()) {
            throw new IllegalArgumentException("JSON with result is null or empty");
        }
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().disableHtmlEscaping().create();
        TwinProperties result = (TwinProperties)gson.fromJson(json, TwinProperties.class);
        return new TwinState(null, result.getDesired(), result.getReported());
    }

    TwinState() {
    }
}

