/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class ParserUtility {
    private static final String DATEFORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String OFFSETFORMAT = "yyyy-MM-dd'T'HH:mm:ssXXX";
    private static final String TIMEZONE = "UTC";
    private static final String SELECT = "select";
    private static final String FROM = "from";
    private static final int NO_MILLISECONDS_IN_DATE = 0;
    private static final int DATE_AND_TIME_IN_DATE = 0;
    private static final int MILLISECONDS_IN_DATE = 1;
    private static final int EXPECTED_PARTS_IN_DATE = 2;
    private static final int MAX_MILLISECONDS_LENGTH_IN_DATE = 3;
    private static final double MILLISECONDS_NUMERIC_BASE = 10.0;
    private static final String MILLISECONDS_REGEX = "[.,Z]";

    public static void validateStringUTF8(String str) throws IllegalArgumentException {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException("parameter is null or empty");
        }
        try {
            if (str.getBytes("UTF-8").length != str.length()) {
                throw new IllegalArgumentException("parameter contains non UTF-8 character");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("parameter contains non UTF-8 character");
        }
    }

    public static void validateQuery(String query) throws IllegalArgumentException {
        try {
            ParserUtility.validateStringUTF8(query);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The provided query is not valid");
        }
        if (!query.toLowerCase().contains(SELECT) || !query.toLowerCase().contains(FROM)) {
            throw new IllegalArgumentException("Query must contain select and from");
        }
    }

    public static void validateBlobName(String blobName) throws IllegalArgumentException {
        try {
            ParserUtility.validateStringUTF8(blobName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The provided blob name is not valid");
        }
        if (blobName.length() > 1024) {
            throw new IllegalArgumentException("The provided blob name exceed maximum size of 1024 characters");
        }
        if (blobName.split("/").length > 254) {
            throw new IllegalArgumentException("The provided blob name exceed 254 path segments");
        }
    }

    public static void validateObject(Object val) throws IllegalArgumentException {
        if (val == null) {
            throw new IllegalArgumentException("parameter is null");
        }
    }

    public static void validateKey(String key, boolean isMetadata) throws IllegalArgumentException {
        try {
            ParserUtility.validateStringUTF8(key);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The provided key is not valid");
        }
        if (key.length() > 128) {
            throw new IllegalArgumentException("The provided key is bigger than 128 characters");
        }
        if (key.contains(".") || key.contains(" ") || key.contains("$") && !isMetadata) {
            throw new IllegalArgumentException("The provided key is not valid");
        }
    }

    public static void validateMap(Map<String, Object> map, int maxLevel, boolean allowMetadata) throws IllegalArgumentException {
        if (maxLevel <= 0) {
            throw new IllegalArgumentException("maxLevel cannot be zero or negative");
        }
        if (map != null) {
            ParserUtility.validateMapInternal(map, 1, maxLevel, allowMetadata);
        }
    }

    private static void validateMapInternal(Map<String, Object> map, int level, int maxLevel, boolean allowMetadata) throws IllegalArgumentException {
        ++level;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            ParserUtility.validateKey(key, allowMetadata);
            if (value != null && (value.getClass().isArray() || value.getClass().isLocalClass())) {
                throw new IllegalArgumentException("Map contains illegal value type " + value.getClass().getName());
            }
            if (value == null || !(value instanceof Map)) continue;
            if (level <= maxLevel) {
                ParserUtility.validateMapInternal((Map)value, level, maxLevel, allowMetadata);
                continue;
            }
            if (ParserUtility.mapOnlyContainsMetaData((Map)value)) continue;
            throw new IllegalArgumentException("Map exceed maximum of " + maxLevel + " levels");
        }
    }

    private static boolean mapOnlyContainsMetaData(Map<String, Object> map) {
        for (String key : map.keySet()) {
            if (key.equals("$lastUpdated") || key.equals("$lastUpdatedVersion")) continue;
            return false;
        }
        return true;
    }

    public static void validateId(String id) throws IllegalArgumentException {
        byte[] chars;
        try {
            ParserUtility.validateStringUTF8(id);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The provided ID is not valid");
        }
        if (id.length() > 128) {
            throw new IllegalArgumentException("The provided ID is bigger than 128 characters");
        }
        for (byte c : chars = id.getBytes()) {
            if (c >= 65 && c <= 90 || c >= 97 && c <= 122 || c >= 48 && c <= 57 || c == 45 || c == 58 || c == 46 || c == 43 || c == 37 || c == 95 || c == 35 || c == 42 || c == 63 || c == 33 || c == 40 || c == 41 || c == 44 || c == 61 || c == 64 || c == 59 || c == 36 || c == 39) continue;
            throw new IllegalArgumentException("The provided ID is not valid");
        }
    }

    public static void validateHostName(String hostName) throws IllegalArgumentException {
        ParserUtility.validateId(hostName);
        if (hostName.split(Pattern.quote(".")).length < 2) {
            throw new IllegalArgumentException("hostName is incomplete");
        }
    }

    public static Date getDateTimeUtc(String dataTime) throws IllegalArgumentException {
        Date dateTimeUtc;
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATEFORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone(TIMEZONE));
        if (dataTime == null || dataTime.isEmpty()) {
            throw new IllegalArgumentException("date is null, empty, or invalid");
        }
        try {
            int milliseconds;
            String[] splitDateTime = dataTime.split(MILLISECONDS_REGEX);
            if (splitDateTime.length > 2) {
                throw new IllegalArgumentException("invalid time:" + dataTime);
            }
            if (splitDateTime.length == 2 && !splitDateTime[1].isEmpty()) {
                int millisecondsLength = splitDateTime[1].length();
                if (millisecondsLength > 3) {
                    millisecondsLength = 3;
                }
                milliseconds = Integer.parseInt(splitDateTime[1].substring(0, millisecondsLength)) * (int)Math.pow(10.0, 3 - millisecondsLength);
            } else {
                milliseconds = 0;
            }
            dateTimeUtc = new Date(dateFormat.parse(splitDateTime[0]).getTime() + (long)milliseconds);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("invalid time:" + dataTime);
        }
        return dateTimeUtc;
    }

    public static Date stringToDateTimeOffset(String dateTime) throws IllegalArgumentException {
        Date dateTimeOffset;
        SimpleDateFormat dateFormat = new SimpleDateFormat(OFFSETFORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone(TIMEZONE));
        if (dateTime == null || dateTime.isEmpty()) {
            throw new IllegalArgumentException("date is null or empty");
        }
        try {
            dateTimeOffset = dateFormat.parse(dateTime);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("invalid time:" + e.toString());
        }
        return dateTimeOffset;
    }

    public static String dateTimeUtcToString(Date date) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("date cannot be null");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATEFORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone(TIMEZONE));
        StringBuilder dateStr = new StringBuilder();
        dateStr.append(dateFormat.format(date));
        dateStr.append(".");
        int milliseconds = (int)(date.getTime() % 1000L);
        milliseconds = milliseconds < 0 ? milliseconds + 1000 : milliseconds;
        dateStr.append(milliseconds);
        dateStr.append("Z");
        return dateStr.toString();
    }

    public static String getDateStringFromDate(Date date) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("The provided date cannot be null");
        }
        return new SimpleDateFormat(DATEFORMAT).format(date);
    }

    public static JsonElement mapToJsonElement(Map<String, Object> map) throws IllegalArgumentException {
        Gson gson = new GsonBuilder().serializeNulls().create();
        JsonObject json = new JsonObject();
        if (map == null) {
            throw new IllegalArgumentException("null map to parse");
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) {
                json.addProperty(entry.getKey(), (String)null);
                continue;
            }
            if (entry.getValue() instanceof Map) {
                json.add(entry.getKey(), ParserUtility.mapToJsonElement((Map)entry.getValue()));
                continue;
            }
            json.add(entry.getKey(), gson.toJsonTree(entry.getValue()));
        }
        return json;
    }

    public static Object resolveJsonElement(JsonElement jsonElement) {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        if (jsonElement.isJsonPrimitive()) {
            return ParserUtility.getJsonPrimitiveValue(jsonElement.getAsJsonPrimitive());
        }
        if (jsonElement.isJsonObject()) {
            return ParserUtility.getJsonObjectValue(jsonElement.getAsJsonObject());
        }
        if (jsonElement.isJsonArray()) {
            return ParserUtility.getJsonArrayValue(jsonElement.getAsJsonArray());
        }
        throw new IllegalArgumentException("Invalid DeviceMethodResponse payload: unknown payload type: " + jsonElement.getClass());
    }

    public static Object getJsonPrimitiveValue(JsonPrimitive jsonPrimitive) {
        if (jsonPrimitive.isNumber()) {
            return jsonPrimitive.getAsNumber();
        }
        if (jsonPrimitive.isBoolean()) {
            return jsonPrimitive.getAsBoolean();
        }
        return jsonPrimitive.getAsString();
    }

    public static Map<String, Object> getJsonObjectValue(JsonObject jsonObject) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            map.put((String)entry.getKey(), ParserUtility.resolveJsonElement((JsonElement)entry.getValue()));
        }
        return map;
    }

    public static List<Object> getJsonArrayValue(JsonArray jsonArray) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (JsonElement element : jsonArray.getAsJsonArray()) {
            list.add(ParserUtility.resolveJsonElement(element));
        }
        return list;
    }
}

