// Template Source: BaseEntityCollectionRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.identitygovernance.models.LifecycleWorkflowsContainer;
import com.microsoft.graph.identitygovernance.models.CustomTaskExtension;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.identitygovernance.requests.CustomTaskExtensionCollectionResponse;
import com.microsoft.graph.identitygovernance.requests.CustomTaskExtensionCollectionRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.CustomTaskExtensionCollectionRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Custom Task Extension Collection Request.
 */
public class CustomTaskExtensionCollectionRequest extends BaseEntityCollectionRequest<CustomTaskExtension, CustomTaskExtensionCollectionResponse, CustomTaskExtensionCollectionPage> {

    /**
     * The request builder for this collection of CustomTaskExtension
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CustomTaskExtensionCollectionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, CustomTaskExtensionCollectionResponse.class, CustomTaskExtensionCollectionPage.class, CustomTaskExtensionCollectionRequestBuilder.class);
    }

    /**
     * Creates a new CustomTaskExtension
     * @param newCustomTaskExtension the CustomTaskExtension to create
     * @return a future with the created object
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CustomTaskExtension> postAsync(@Nonnull final CustomTaskExtension newCustomTaskExtension) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new CustomTaskExtensionRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .postAsync(newCustomTaskExtension);
    }

    /**
     * Creates a new CustomTaskExtension
     * @param newCustomTaskExtension the CustomTaskExtension to create
     * @return the newly created object
     */
    @Nonnull
    public CustomTaskExtension post(@Nonnull final CustomTaskExtension newCustomTaskExtension) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new CustomTaskExtensionRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .post(newCustomTaskExtension);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    @Nonnull
    public CustomTaskExtensionCollectionRequest expand(@Nonnull final String value) {
        addExpandOption(value);
        return this;
    }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    @Nonnull
    public CustomTaskExtensionCollectionRequest filter(@Nonnull final String value) {
        addFilterOption(value);
        return this;
    }

    /**
     * Sets the order by clause for the request
     *
     * @param value the order by clause
     * @return the updated request
     */
    @Nonnull
    public CustomTaskExtensionCollectionRequest orderBy(@Nonnull final String value) {
        addOrderByOption(value);
        return this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    @Nonnull
    public CustomTaskExtensionCollectionRequest select(@Nonnull final String value) {
        addSelectOption(value);
        return this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    @Nonnull
    public CustomTaskExtensionCollectionRequest top(final int value) {
        addTopOption(value);
        return this;
    }

    /**
     * Sets the count value for the request
     *
     * @param value whether or not to return the count of objects with the request
     * @return the updated request
     */
    @Nonnull
    public CustomTaskExtensionCollectionRequest count(final boolean value) {
        addCountOption(value);
        return this;
    }
    /**
     * Sets the count value to true for the request
     *
     * @return the updated request
     */
    @Nonnull
    public CustomTaskExtensionCollectionRequest count() {
        addCountOption(true);
        return this;
    }
    /**
     * Sets the skip value for the request
     *
     * @param value of the number of items to skip
     * @return the updated request
     */
    @Nonnull
    public CustomTaskExtensionCollectionRequest skip(final int value) {
        addSkipOption(value);
        return this;
    }


    /**
     * Add Skip token for pagination
     * @param skipToken - Token for pagination
     * @return the updated request
     */
    @Nonnull
    public CustomTaskExtensionCollectionRequest skipToken(@Nonnull final String skipToken) {
    	addSkipTokenOption(skipToken);
        return this;
    }
}

