// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.identitygovernance.models.WorkflowTriggerTimeBasedAttribute;
import com.microsoft.graph.identitygovernance.models.WorkflowExecutionTrigger;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Time Based Attribute Trigger.
 */
public class TimeBasedAttributeTrigger extends WorkflowExecutionTrigger implements IJsonBackedObject {


    /**
     * The Offset In Days.
     * How many days before or after the time-based attribute specified the workflow should trigger. For example, if the attribute is employeeHireDate and offsetInDays is -1, then the workflow should trigger one day before the employee hire date. The value can range between -180 and 180 days.
     */
    @SerializedName(value = "offsetInDays", alternate = {"OffsetInDays"})
    @Expose
	@Nullable
    public Integer offsetInDays;

    /**
     * The Time Based Attribute.
     * Determines which time-based identity property to reference. The possible values are: employeeHireDate, employeeLeaveDateTime, createdDateTime, unknownFutureValue.
     */
    @SerializedName(value = "timeBasedAttribute", alternate = {"TimeBasedAttribute"})
    @Expose
	@Nullable
    public WorkflowTriggerTimeBasedAttribute timeBasedAttribute;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
