// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.identitygovernance.models.CustomTaskExtension;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Custom Task Extension Request.
 */
public class CustomTaskExtensionRequest extends BaseRequest<CustomTaskExtension> {
	
    /**
     * The request for the CustomTaskExtension
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CustomTaskExtensionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, CustomTaskExtension.class);
    }

    /**
     * Gets the CustomTaskExtension from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CustomTaskExtension> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the CustomTaskExtension from the service
     *
     * @return the CustomTaskExtension from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CustomTaskExtension get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CustomTaskExtension> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public CustomTaskExtension delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this CustomTaskExtension with a source
     *
     * @param sourceCustomTaskExtension the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CustomTaskExtension> patchAsync(@Nonnull final CustomTaskExtension sourceCustomTaskExtension) {
        return sendAsync(HttpMethod.PATCH, sourceCustomTaskExtension);
    }

    /**
     * Patches this CustomTaskExtension with a source
     *
     * @param sourceCustomTaskExtension the source object with updates
     * @return the updated CustomTaskExtension
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CustomTaskExtension patch(@Nonnull final CustomTaskExtension sourceCustomTaskExtension) throws ClientException {
        return send(HttpMethod.PATCH, sourceCustomTaskExtension);
    }

    /**
     * Creates a CustomTaskExtension with a new object
     *
     * @param newCustomTaskExtension the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CustomTaskExtension> postAsync(@Nonnull final CustomTaskExtension newCustomTaskExtension) {
        return sendAsync(HttpMethod.POST, newCustomTaskExtension);
    }

    /**
     * Creates a CustomTaskExtension with a new object
     *
     * @param newCustomTaskExtension the new object to create
     * @return the created CustomTaskExtension
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CustomTaskExtension post(@Nonnull final CustomTaskExtension newCustomTaskExtension) throws ClientException {
        return send(HttpMethod.POST, newCustomTaskExtension);
    }

    /**
     * Creates a CustomTaskExtension with a new object
     *
     * @param newCustomTaskExtension the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CustomTaskExtension> putAsync(@Nonnull final CustomTaskExtension newCustomTaskExtension) {
        return sendAsync(HttpMethod.PUT, newCustomTaskExtension);
    }

    /**
     * Creates a CustomTaskExtension with a new object
     *
     * @param newCustomTaskExtension the object to create/update
     * @return the created CustomTaskExtension
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CustomTaskExtension put(@Nonnull final CustomTaskExtension newCustomTaskExtension) throws ClientException {
        return send(HttpMethod.PUT, newCustomTaskExtension);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public CustomTaskExtensionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public CustomTaskExtensionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

