// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.requests;
import com.microsoft.graph.identitygovernance.requests.WorkflowCreateNewVersionRequest;
import com.microsoft.graph.identitygovernance.models.Workflow;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.identitygovernance.models.WorkflowCreateNewVersionParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workflow Create New Version Request Builder.
 */
public class WorkflowCreateNewVersionRequestBuilder extends BaseActionRequestBuilder<Workflow> {

    /**
     * The request builder for this WorkflowCreateNewVersion
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkflowCreateNewVersionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private WorkflowCreateNewVersionParameterSet body;
    /**
     * The request builder for this WorkflowCreateNewVersion
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public WorkflowCreateNewVersionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final WorkflowCreateNewVersionParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the WorkflowCreateNewVersionRequest
     *
     * @param requestOptions the options for the request
     * @return the WorkflowCreateNewVersionRequest instance
     */
    @Nonnull
    public WorkflowCreateNewVersionRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the WorkflowCreateNewVersionRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the WorkflowCreateNewVersionRequest instance
     */
    @Nonnull
    public WorkflowCreateNewVersionRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final WorkflowCreateNewVersionRequest request = new WorkflowCreateNewVersionRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
