// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.AccessPackageQuestion;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Text Input Question.
 */
public class AccessPackageTextInputQuestion extends AccessPackageQuestion implements IJsonBackedObject {


    /**
     * The Is Single Line Question.
     * Indicates whether the answer will be in single or multiple line format.
     */
    @SerializedName(value = "isSingleLineQuestion", alternate = {"IsSingleLineQuestion"})
    @Expose
	@Nullable
    public Boolean isSingleLineQuestion;

    /**
     * The Regex Pattern.
     * The regular expression pattern which any answer to this question must match.
     */
    @SerializedName(value = "regexPattern", alternate = {"RegexPattern"})
    @Expose
	@Nullable
    public String regexPattern;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
