// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.AttributeFlowBehavior;
import com.microsoft.graph.models.AttributeFlowType;
import com.microsoft.graph.models.AttributeMappingSource;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Attribute Mapping.
 */
public class AttributeMapping implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Default Value.
     * Default value to be used in case the source property was evaluated to null. Optional.
     */
    @SerializedName(value = "defaultValue", alternate = {"DefaultValue"})
    @Expose
	@Nullable
    public String defaultValue;

    /**
     * The Export Missing References.
     * For internal use only.
     */
    @SerializedName(value = "exportMissingReferences", alternate = {"ExportMissingReferences"})
    @Expose
	@Nullable
    public Boolean exportMissingReferences;

    /**
     * The Flow Behavior.
     * Defines when this attribute should be exported to the target directory. Possible values are: FlowWhenChanged and FlowAlways. Default is FlowWhenChanged.
     */
    @SerializedName(value = "flowBehavior", alternate = {"FlowBehavior"})
    @Expose
	@Nullable
    public AttributeFlowBehavior flowBehavior;

    /**
     * The Flow Type.
     * Defines when this attribute should be updated in the target directory. Possible values are: Always (default) ObjectAddOnly - only when new object is created  MultiValueAddOnly - only when the change is adding new values to a multi-valued attribute  ValueAddOnly - If there is a current value, only flows 'Add' operations; will not flow 'Remove' operations   AttributeAddOnly - Only propagates changes if no current value exists at all
     */
    @SerializedName(value = "flowType", alternate = {"FlowType"})
    @Expose
	@Nullable
    public AttributeFlowType flowType;

    /**
     * The Matching Priority.
     * If higher than 0, this attribute will be used to perform an initial match of the objects between source and target directories. The synchronization engine will try to find the matching object using attribute with lowest value of matching priority first. If not found, the attribute with the next matching priority will be used, and so on a until match is found or no more matching attributes are left. Only attributes that are expected to have unique values, such as email, should be used as matching attributes.
     */
    @SerializedName(value = "matchingPriority", alternate = {"MatchingPriority"})
    @Expose
	@Nullable
    public Integer matchingPriority;

    /**
     * The Source.
     * Defines how a value should be extracted (or transformed) from the source object.
     */
    @SerializedName(value = "source", alternate = {"Source"})
    @Expose
	@Nullable
    public AttributeMappingSource source;

    /**
     * The Target Attribute Name.
     * Name of the attribute on the target object.
     */
    @SerializedName(value = "targetAttributeName", alternate = {"TargetAttributeName"})
    @Expose
	@Nullable
    public String targetAttributeName;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
