// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.EmailAuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.Fido2AuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.AuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.MicrosoftAuthenticatorAuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.LongRunningOperationCollectionPage;
import com.microsoft.graph.requests.PasswordAuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.PhoneAuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.SoftwareOathAuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.TemporaryAccessPassAuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.WindowsHelloForBusinessAuthenticationMethodCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication.
 */
public class Authentication extends Entity implements IJsonBackedObject {


    /**
     * The Email Methods.
     * The email address registered to a user for authentication.
     */
    @SerializedName(value = "emailMethods", alternate = {"EmailMethods"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.EmailAuthenticationMethodCollectionPage emailMethods;

    /**
     * The Fido2Methods.
     * Represents the FIDO2 security keys registered to a user for authentication.
     */
    @SerializedName(value = "fido2Methods", alternate = {"Fido2Methods"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.Fido2AuthenticationMethodCollectionPage fido2Methods;

    /**
     * The Methods.
     * Represents all authentication methods registered to a user.
     */
    @SerializedName(value = "methods", alternate = {"Methods"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.AuthenticationMethodCollectionPage methods;

    /**
     * The Microsoft Authenticator Methods.
     * The details of the Microsoft Authenticator app registered to a user for authentication.
     */
    @SerializedName(value = "microsoftAuthenticatorMethods", alternate = {"MicrosoftAuthenticatorMethods"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.MicrosoftAuthenticatorAuthenticationMethodCollectionPage microsoftAuthenticatorMethods;

    /**
     * The Operations.
     * Represents the status of a long-running operation.
     */
    @SerializedName(value = "operations", alternate = {"Operations"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.LongRunningOperationCollectionPage operations;

    /**
     * The Password Methods.
     * Represents the password that's registered to a user for authentication. For security, the password itself will never be returned in the object, but action can be taken to reset a password.
     */
    @SerializedName(value = "passwordMethods", alternate = {"PasswordMethods"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.PasswordAuthenticationMethodCollectionPage passwordMethods;

    /**
     * The Phone Methods.
     * The phone numbers registered to a user for authentication.
     */
    @SerializedName(value = "phoneMethods", alternate = {"PhoneMethods"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.PhoneAuthenticationMethodCollectionPage phoneMethods;

    /**
     * The Software Oath Methods.
     * The software OATH TOTP applications registered to a user for authentication.
     */
    @SerializedName(value = "softwareOathMethods", alternate = {"SoftwareOathMethods"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.SoftwareOathAuthenticationMethodCollectionPage softwareOathMethods;

    /**
     * The Temporary Access Pass Methods.
     * Represents a Temporary Access Pass registered to a user for authentication through time-limited passcodes.
     */
    @SerializedName(value = "temporaryAccessPassMethods", alternate = {"TemporaryAccessPassMethods"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.TemporaryAccessPassAuthenticationMethodCollectionPage temporaryAccessPassMethods;

    /**
     * The Windows Hello For Business Methods.
     * Represents the Windows Hello for Business authentication method registered to a user for authentication.
     */
    @SerializedName(value = "windowsHelloForBusinessMethods", alternate = {"WindowsHelloForBusinessMethods"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.WindowsHelloForBusinessAuthenticationMethodCollectionPage windowsHelloForBusinessMethods;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("emailMethods")) {
            emailMethods = serializer.deserializeObject(json.get("emailMethods"), com.microsoft.graph.requests.EmailAuthenticationMethodCollectionPage.class);
        }

        if (json.has("fido2Methods")) {
            fido2Methods = serializer.deserializeObject(json.get("fido2Methods"), com.microsoft.graph.requests.Fido2AuthenticationMethodCollectionPage.class);
        }

        if (json.has("methods")) {
            methods = serializer.deserializeObject(json.get("methods"), com.microsoft.graph.requests.AuthenticationMethodCollectionPage.class);
        }

        if (json.has("microsoftAuthenticatorMethods")) {
            microsoftAuthenticatorMethods = serializer.deserializeObject(json.get("microsoftAuthenticatorMethods"), com.microsoft.graph.requests.MicrosoftAuthenticatorAuthenticationMethodCollectionPage.class);
        }

        if (json.has("operations")) {
            operations = serializer.deserializeObject(json.get("operations"), com.microsoft.graph.requests.LongRunningOperationCollectionPage.class);
        }

        if (json.has("passwordMethods")) {
            passwordMethods = serializer.deserializeObject(json.get("passwordMethods"), com.microsoft.graph.requests.PasswordAuthenticationMethodCollectionPage.class);
        }

        if (json.has("phoneMethods")) {
            phoneMethods = serializer.deserializeObject(json.get("phoneMethods"), com.microsoft.graph.requests.PhoneAuthenticationMethodCollectionPage.class);
        }

        if (json.has("softwareOathMethods")) {
            softwareOathMethods = serializer.deserializeObject(json.get("softwareOathMethods"), com.microsoft.graph.requests.SoftwareOathAuthenticationMethodCollectionPage.class);
        }

        if (json.has("temporaryAccessPassMethods")) {
            temporaryAccessPassMethods = serializer.deserializeObject(json.get("temporaryAccessPassMethods"), com.microsoft.graph.requests.TemporaryAccessPassAuthenticationMethodCollectionPage.class);
        }

        if (json.has("windowsHelloForBusinessMethods")) {
            windowsHelloForBusinessMethods = serializer.deserializeObject(json.get("windowsHelloForBusinessMethods"), com.microsoft.graph.requests.WindowsHelloForBusinessAuthenticationMethodCollectionPage.class);
        }
    }
}
