// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Booking Scheduling Policy.
 */
public class BookingSchedulingPolicy implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Allow Staff Selection.
     * True if to allow customers to choose a specific person for the booking.
     */
    @SerializedName(value = "allowStaffSelection", alternate = {"AllowStaffSelection"})
    @Expose
	@Nullable
    public Boolean allowStaffSelection;

    /**
     * The Maximum Advance.
     * Maximum number of days in advance that a booking can be made. It follows the ISO 8601 format.
     */
    @SerializedName(value = "maximumAdvance", alternate = {"MaximumAdvance"})
    @Expose
	@Nullable
    public javax.xml.datatype.Duration maximumAdvance;

    /**
     * The Minimum Lead Time.
     * The minimum amount of time before which bookings and cancellations must be made. It follows the ISO 8601 format.
     */
    @SerializedName(value = "minimumLeadTime", alternate = {"MinimumLeadTime"})
    @Expose
	@Nullable
    public javax.xml.datatype.Duration minimumLeadTime;

    /**
     * The Send Confirmations To Owner.
     * True to notify the business via email when a booking is created or changed. Use the email address specified in the email property of the bookingBusiness entity for the business.
     */
    @SerializedName(value = "sendConfirmationsToOwner", alternate = {"SendConfirmationsToOwner"})
    @Expose
	@Nullable
    public Boolean sendConfirmationsToOwner;

    /**
     * The Time Slot Interval.
     * Duration of each time slot, denoted in ISO 8601 format.
     */
    @SerializedName(value = "timeSlotInterval", alternate = {"TimeSlotInterval"})
    @Expose
	@Nullable
    public javax.xml.datatype.Duration timeSlotInterval;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
