// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.DefenderThreatAction;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Defender Detected Malware Actions.
 */
public class DefenderDetectedMalwareActions implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The High Severity.
     * Indicates a Defender action to take for high severity Malware threat detected. Possible values are: deviceDefault, clean, quarantine, remove, allow, userDefined, block.
     */
    @SerializedName(value = "highSeverity", alternate = {"HighSeverity"})
    @Expose
	@Nullable
    public DefenderThreatAction highSeverity;

    /**
     * The Low Severity.
     * Indicates a Defender action to take for low severity Malware threat detected. Possible values are: deviceDefault, clean, quarantine, remove, allow, userDefined, block.
     */
    @SerializedName(value = "lowSeverity", alternate = {"LowSeverity"})
    @Expose
	@Nullable
    public DefenderThreatAction lowSeverity;

    /**
     * The Moderate Severity.
     * Indicates a Defender action to take for moderate severity Malware threat detected. Possible values are: deviceDefault, clean, quarantine, remove, allow, userDefined, block.
     */
    @SerializedName(value = "moderateSeverity", alternate = {"ModerateSeverity"})
    @Expose
	@Nullable
    public DefenderThreatAction moderateSeverity;

    /**
     * The Severe Severity.
     * Indicates a Defender action to take for severe severity Malware threat detected. Possible values are: deviceDefault, clean, quarantine, remove, allow, userDefined, block.
     */
    @SerializedName(value = "severeSeverity", alternate = {"SevereSeverity"})
    @Expose
	@Nullable
    public DefenderThreatAction severeSeverity;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
