// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.DeviceEnrollmentPlatformRestriction;
import com.microsoft.graph.models.DeviceEnrollmentConfiguration;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Enrollment Platform Restrictions Configuration.
 */
public class DeviceEnrollmentPlatformRestrictionsConfiguration extends DeviceEnrollmentConfiguration implements IJsonBackedObject {


    /**
     * The Android Restriction.
     * Android restrictions based on platform, platform operating system version, and device ownership
     */
    @SerializedName(value = "androidRestriction", alternate = {"AndroidRestriction"})
    @Expose
	@Nullable
    public DeviceEnrollmentPlatformRestriction androidRestriction;

    /**
     * The Ios Restriction.
     * Ios restrictions based on platform, platform operating system version, and device ownership
     */
    @SerializedName(value = "iosRestriction", alternate = {"IosRestriction"})
    @Expose
	@Nullable
    public DeviceEnrollmentPlatformRestriction iosRestriction;

    /**
     * The Mac OSRestriction.
     * Mac restrictions based on platform, platform operating system version, and device ownership
     */
    @SerializedName(value = "macOSRestriction", alternate = {"MacOSRestriction"})
    @Expose
	@Nullable
    public DeviceEnrollmentPlatformRestriction macOSRestriction;

    /**
     * The Windows Mobile Restriction.
     * Windows mobile restrictions based on platform, platform operating system version, and device ownership
     */
    @SerializedName(value = "windowsMobileRestriction", alternate = {"WindowsMobileRestriction"})
    @Expose
	@Nullable
    public DeviceEnrollmentPlatformRestriction windowsMobileRestriction;

    /**
     * The Windows Restriction.
     * Windows restrictions based on platform, platform operating system version, and device ownership
     */
    @SerializedName(value = "windowsRestriction", alternate = {"WindowsRestriction"})
    @Expose
	@Nullable
    public DeviceEnrollmentPlatformRestriction windowsRestriction;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
