// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.AppLogUploadState;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Log Collection Response.
 */
public class DeviceLogCollectionResponse extends Entity implements IJsonBackedObject {


    /**
     * The Enrolled By User.
     * The User Principal Name (UPN) of the user that enrolled the device.
     */
    @SerializedName(value = "enrolledByUser", alternate = {"EnrolledByUser"})
    @Expose
	@Nullable
    public String enrolledByUser;

    /**
     * The Expiration Date Time UTC.
     * The DateTime of the expiration of the logs.
     */
    @SerializedName(value = "expirationDateTimeUTC", alternate = {"ExpirationDateTimeUTC"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime expirationDateTimeUTC;

    /**
     * The Initiated By User Principal Name.
     * The UPN for who initiated the request.
     */
    @SerializedName(value = "initiatedByUserPrincipalName", alternate = {"InitiatedByUserPrincipalName"})
    @Expose
	@Nullable
    public String initiatedByUserPrincipalName;

    /**
     * The Managed Device Id.
     * Indicates Intune device unique identifier.
     */
    @SerializedName(value = "managedDeviceId", alternate = {"ManagedDeviceId"})
    @Expose
	@Nullable
    public java.util.UUID managedDeviceId;

    /**
     * The Received Date Time UTC.
     * The DateTime the request was received.
     */
    @SerializedName(value = "receivedDateTimeUTC", alternate = {"ReceivedDateTimeUTC"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime receivedDateTimeUTC;

    /**
     * The Requested Date Time UTC.
     * The DateTime of the request.
     */
    @SerializedName(value = "requestedDateTimeUTC", alternate = {"RequestedDateTimeUTC"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime requestedDateTimeUTC;

    /**
     * The Size In KB.
     * The size of the logs in KB. Valid values -1.79769313486232E+308 to 1.79769313486232E+308
     */
    @SerializedName(value = "sizeInKB", alternate = {"SizeInKB"})
    @Expose
	@Nullable
    public Double sizeInKB;

    /**
     * The Status.
     * Indicates the status for the app log collection request if it is pending, completed or failed, Default is pending. Possible values are: pending, completed, failed, unknownFutureValue.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public AppLogUploadState status;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
