// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.IdentitySet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Incoming Context.
 */
public class IncomingContext implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Observed Participant Id.
     * The ID of the participant that is under observation. Read-only.
     */
    @SerializedName(value = "observedParticipantId", alternate = {"ObservedParticipantId"})
    @Expose
	@Nullable
    public String observedParticipantId;

    /**
     * The On Behalf Of.
     * The identity that the call is happening on behalf of.
     */
    @SerializedName(value = "onBehalfOf", alternate = {"OnBehalfOf"})
    @Expose
	@Nullable
    public IdentitySet onBehalfOf;

    /**
     * The Source Participant Id.
     * The ID of the participant that triggered the incoming call. Read-only.
     */
    @SerializedName(value = "sourceParticipantId", alternate = {"SourceParticipantId"})
    @Expose
	@Nullable
    public String sourceParticipantId;

    /**
     * The Transferor.
     * The identity that transferred the call.
     */
    @SerializedName(value = "transferor", alternate = {"Transferor"})
    @Expose
	@Nullable
    public IdentitySet transferor;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
