// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Informational Url.
 */
public class InformationalUrl implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Logo Url.
     * CDN URL to the application's logo, Read-only.
     */
    @SerializedName(value = "logoUrl", alternate = {"LogoUrl"})
    @Expose
	@Nullable
    public String logoUrl;

    /**
     * The Marketing Url.
     * Link to the application's marketing page. For example, https://www.contoso.com/app/marketing
     */
    @SerializedName(value = "marketingUrl", alternate = {"MarketingUrl"})
    @Expose
	@Nullable
    public String marketingUrl;

    /**
     * The Privacy Statement Url.
     * Link to the application's privacy statement. For example, https://www.contoso.com/app/privacy
     */
    @SerializedName(value = "privacyStatementUrl", alternate = {"PrivacyStatementUrl"})
    @Expose
	@Nullable
    public String privacyStatementUrl;

    /**
     * The Support Url.
     * Link to the application's support page. For example, https://www.contoso.com/app/support
     */
    @SerializedName(value = "supportUrl", alternate = {"SupportUrl"})
    @Expose
	@Nullable
    public String supportUrl;

    /**
     * The Terms Of Service Url.
     * Link to the application's terms of service statement. For example, https://www.contoso.com/app/termsofservice
     */
    @SerializedName(value = "termsOfServiceUrl", alternate = {"TermsOfServiceUrl"})
    @Expose
	@Nullable
    public String termsOfServiceUrl;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
