// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.CourseStatus;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Learning Course Activity.
 */
public class LearningCourseActivity extends Entity implements IJsonBackedObject {


    /**
     * The Completed Date Time.
     * Date and time when the assignment was completed. Optional.
     */
    @SerializedName(value = "completedDateTime", alternate = {"CompletedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime completedDateTime;

    /**
     * The Completion Percentage.
     * The percentage completion value of the course activity. Optional.
     */
    @SerializedName(value = "completionPercentage", alternate = {"CompletionPercentage"})
    @Expose
	@Nullable
    public Integer completionPercentage;

    /**
     * The Externalcourse Activity Id.
     * A course activity ID generated by the provider. Optional.
     */
    @SerializedName(value = "externalcourseActivityId", alternate = {"ExternalcourseActivityId"})
    @Expose
	@Nullable
    public String externalcourseActivityId;

    /**
     * The Learner User Id.
     * The user ID of the learner to whom the activity is assigned. Required.
     */
    @SerializedName(value = "learnerUserId", alternate = {"LearnerUserId"})
    @Expose
	@Nullable
    public String learnerUserId;

    /**
     * The Learning Content Id.
     * The ID of the learning content created in Viva Learning. Required.
     */
    @SerializedName(value = "learningContentId", alternate = {"LearningContentId"})
    @Expose
	@Nullable
    public String learningContentId;

    /**
     * The Learning Provider Id.
     * The registration ID of the provider. Required.
     */
    @SerializedName(value = "learningProviderId", alternate = {"LearningProviderId"})
    @Expose
	@Nullable
    public String learningProviderId;

    /**
     * The Status.
     * The status of the course activity. Possible values are: notStarted, inProgress, completed. Required.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public CourseStatus status;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
