// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.ManagedEBookAssignment;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed EBook Assign Parameter Set.
 */
public class ManagedEBookAssignParameterSet {
    /**
     * The managed EBook Assignments.
     * 
     */
    @SerializedName(value = "managedEBookAssignments", alternate = {"ManagedEBookAssignments"})
    @Expose
	@Nullable
    public java.util.List<ManagedEBookAssignment> managedEBookAssignments;


    /**
     * Instiaciates a new ManagedEBookAssignParameterSet
     */
    public ManagedEBookAssignParameterSet() {}
    /**
     * Instiaciates a new ManagedEBookAssignParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ManagedEBookAssignParameterSet(@Nonnull final ManagedEBookAssignParameterSetBuilder builder) {
        this.managedEBookAssignments = builder.managedEBookAssignments;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ManagedEBookAssignParameterSetBuilder newBuilder() {
        return new ManagedEBookAssignParameterSetBuilder();
    }
    /**
     * Fluent builder for the ManagedEBookAssignParameterSet
     */
    public static final class ManagedEBookAssignParameterSetBuilder {
        /**
         * The managedEBookAssignments parameter value
         */
        @Nullable
        protected java.util.List<ManagedEBookAssignment> managedEBookAssignments;
        /**
         * Sets the ManagedEBookAssignments
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ManagedEBookAssignParameterSetBuilder withManagedEBookAssignments(@Nullable final java.util.List<ManagedEBookAssignment> val) {
            this.managedEBookAssignments = val;
            return this;
        }
        /**
         * Instanciates a new ManagedEBookAssignParameterSetBuilder
         */
        @Nullable
        protected ManagedEBookAssignParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ManagedEBookAssignParameterSet build() {
            return new ManagedEBookAssignParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.managedEBookAssignments != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("managedEBookAssignments", managedEBookAssignments));
        }
        return result;
    }
}
