// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.LoginPageLayoutConfiguration;
import com.microsoft.graph.models.LoginPageTextVisibilitySettings;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Organizational Branding Properties.
 */
public class OrganizationalBrandingProperties extends Entity implements IJsonBackedObject {


    /**
     * The Background Color.
     * Color that appears in place of the background image in low-bandwidth connections. We recommend that you use the primary color of your banner logo or your organization color. Specify this in hexadecimal format, for example, white is #FFFFFF.
     */
    @SerializedName(value = "backgroundColor", alternate = {"BackgroundColor"})
    @Expose
	@Nullable
    public String backgroundColor;

    /**
     * The Background Image Relative Url.
     * A relative URL for the backgroundImage property that is combined with a CDN base URL from the cdnList to provide the version served by a CDN. Read-only.
     */
    @SerializedName(value = "backgroundImageRelativeUrl", alternate = {"BackgroundImageRelativeUrl"})
    @Expose
	@Nullable
    public String backgroundImageRelativeUrl;

    /**
     * The Banner Logo Relative Url.
     * A relative URL for the bannerLogo property that is combined with a CDN base URL from the cdnList to provide the read-only version served by a CDN. Read-only.
     */
    @SerializedName(value = "bannerLogoRelativeUrl", alternate = {"BannerLogoRelativeUrl"})
    @Expose
	@Nullable
    public String bannerLogoRelativeUrl;

    /**
     * The Cdn List.
     * A list of base URLs for all available CDN providers that are serving the assets of the current resource. Several CDN providers are used at the same time for high availability of read requests. Read-only.
     */
    @SerializedName(value = "cdnList", alternate = {"CdnList"})
    @Expose
	@Nullable
    public java.util.List<String> cdnList;

    /**
     * The Custom Account Reset Credentials Url.
     * A custom URL for resetting account credentials. This URL must be in ASCII format or non-ASCII characters must be URL encoded, and not exceed 128 characters.
     */
    @SerializedName(value = "customAccountResetCredentialsUrl", alternate = {"CustomAccountResetCredentialsUrl"})
    @Expose
	@Nullable
    public String customAccountResetCredentialsUrl;

    /**
     * The Custom Cannot Access Your Account Text.
     * A string to replace the default 'Can't access your account?' self-service password reset (SSPR) hyperlink text on the sign-in page. This text must be in Unicode format and not exceed 256 characters.
     */
    @SerializedName(value = "customCannotAccessYourAccountText", alternate = {"CustomCannotAccessYourAccountText"})
    @Expose
	@Nullable
    public String customCannotAccessYourAccountText;

    /**
     * The Custom Cannot Access Your Account Url.
     * A custom URL to replace the default URL of the self-service password reset (SSPR) 'Can't access your account?' hyperlink on the sign-in page. This URL must be in ASCII format or non-ASCII characters must be URL encoded, and not exceed 128 characters. DO NOT USE. Use customAccountResetCredentialsUrl instead.
     */
    @SerializedName(value = "customCannotAccessYourAccountUrl", alternate = {"CustomCannotAccessYourAccountUrl"})
    @Expose
	@Nullable
    public String customCannotAccessYourAccountUrl;

    /**
     * The Custom CSSRelative Url.
     * A relative URL for the customCSS property that is combined with a CDN base URL from the cdnList to provide the version served by a CDN. Read-only.
     */
    @SerializedName(value = "customCSSRelativeUrl", alternate = {"CustomCSSRelativeUrl"})
    @Expose
	@Nullable
    public String customCSSRelativeUrl;

    /**
     * The Custom Forgot My Password Text.
     * A string to replace the default 'Forgot my password' hyperlink text on the sign-in form. This text must be in Unicode format and not exceed 256 characters.
     */
    @SerializedName(value = "customForgotMyPasswordText", alternate = {"CustomForgotMyPasswordText"})
    @Expose
	@Nullable
    public String customForgotMyPasswordText;

    /**
     * The Custom Privacy And Cookies Text.
     * A string to replace the default 'Privacy and Cookies' hyperlink text in the footer. This text must be in Unicode format and not exceed 256 characters.
     */
    @SerializedName(value = "customPrivacyAndCookiesText", alternate = {"CustomPrivacyAndCookiesText"})
    @Expose
	@Nullable
    public String customPrivacyAndCookiesText;

    /**
     * The Custom Privacy And Cookies Url.
     * A custom URL to replace the default URL of the 'Privacy and Cookies' hyperlink in the footer. This URL must be in ASCII format or non-ASCII characters must be URL encoded, and not exceed 128 characters.
     */
    @SerializedName(value = "customPrivacyAndCookiesUrl", alternate = {"CustomPrivacyAndCookiesUrl"})
    @Expose
	@Nullable
    public String customPrivacyAndCookiesUrl;

    /**
     * The Custom Reset It Now Text.
     * A string to replace the default 'reset it now' hyperlink text on the sign-in form. This text must be in Unicode format and not exceed 256 characters. DO NOT USE: Customization of the 'reset it now' hyperlink text is currently not supported.
     */
    @SerializedName(value = "customResetItNowText", alternate = {"CustomResetItNowText"})
    @Expose
	@Nullable
    public String customResetItNowText;

    /**
     * The Custom Terms Of Use Text.
     * A string to replace the the default 'Terms of Use' hyperlink text in the footer. This text must be in Unicode format and not exceed 256 characters.
     */
    @SerializedName(value = "customTermsOfUseText", alternate = {"CustomTermsOfUseText"})
    @Expose
	@Nullable
    public String customTermsOfUseText;

    /**
     * The Custom Terms Of Use Url.
     * A custom URL to replace the default URL of the 'Terms of Use' hyperlink in the footer. This URL must be in ASCII format or non-ASCII characters must be URL encoded, and not exceed 128characters.
     */
    @SerializedName(value = "customTermsOfUseUrl", alternate = {"CustomTermsOfUseUrl"})
    @Expose
	@Nullable
    public String customTermsOfUseUrl;

    /**
     * The Favicon Relative Url.
     * A relative url for the favicon above that is combined with a CDN base URL from the cdnList to provide the version served by a CDN. Read-only.
     */
    @SerializedName(value = "faviconRelativeUrl", alternate = {"FaviconRelativeUrl"})
    @Expose
	@Nullable
    public String faviconRelativeUrl;

    /**
     * The Header Background Color.
     * The RGB color to apply to customize the color of the header.
     */
    @SerializedName(value = "headerBackgroundColor", alternate = {"HeaderBackgroundColor"})
    @Expose
	@Nullable
    public String headerBackgroundColor;

    /**
     * The Header Logo Relative Url.
     * A relative URL for the headerLogo property that is combined with a CDN base URL from the cdnList to provide the read-only version served by a CDN. Read-only.
     */
    @SerializedName(value = "headerLogoRelativeUrl", alternate = {"HeaderLogoRelativeUrl"})
    @Expose
	@Nullable
    public String headerLogoRelativeUrl;

    /**
     * The Login Page Layout Configuration.
     * Represents the layout configuration to be displayed on the login page for a tenant.
     */
    @SerializedName(value = "loginPageLayoutConfiguration", alternate = {"LoginPageLayoutConfiguration"})
    @Expose
	@Nullable
    public LoginPageLayoutConfiguration loginPageLayoutConfiguration;

    /**
     * The Login Page Text Visibility Settings.
     * Represents the various texts that can be hidden on the login page for a tenant.
     */
    @SerializedName(value = "loginPageTextVisibilitySettings", alternate = {"LoginPageTextVisibilitySettings"})
    @Expose
	@Nullable
    public LoginPageTextVisibilitySettings loginPageTextVisibilitySettings;

    /**
     * The Sign In Page Text.
     * Text that appears at the bottom of the sign-in box. Use this to communicate additional information, such as the phone number to your help desk or a legal statement. This text must be in Unicode format and not exceed 1024 characters.
     */
    @SerializedName(value = "signInPageText", alternate = {"SignInPageText"})
    @Expose
	@Nullable
    public String signInPageText;

    /**
     * The Square Logo Dark Relative Url.
     * A relative URL for the squareLogoDark property that is combined with a CDN base URL from the cdnList to provide the version served by a CDN. Read-only.
     */
    @SerializedName(value = "squareLogoDarkRelativeUrl", alternate = {"SquareLogoDarkRelativeUrl"})
    @Expose
	@Nullable
    public String squareLogoDarkRelativeUrl;

    /**
     * The Square Logo Relative Url.
     * A relative URL for the squareLogo property that is combined with a CDN base URL from the cdnList to provide the version served by a CDN. Read-only.
     */
    @SerializedName(value = "squareLogoRelativeUrl", alternate = {"SquareLogoRelativeUrl"})
    @Expose
	@Nullable
    public String squareLogoRelativeUrl;

    /**
     * The Username Hint Text.
     * A string that shows as the hint in the username textbox on the sign-in screen. This text must be a Unicode, without links or code, and can't exceed 64 characters.
     */
    @SerializedName(value = "usernameHintText", alternate = {"UsernameHintText"})
    @Expose
	@Nullable
    public String usernameHintText;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
