// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Presence Clear Presence Parameter Set.
 */
public class PresenceClearPresenceParameterSet {
    /**
     * The session Id.
     * 
     */
    @SerializedName(value = "sessionId", alternate = {"SessionId"})
    @Expose
	@Nullable
    public String sessionId;


    /**
     * Instiaciates a new PresenceClearPresenceParameterSet
     */
    public PresenceClearPresenceParameterSet() {}
    /**
     * Instiaciates a new PresenceClearPresenceParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected PresenceClearPresenceParameterSet(@Nonnull final PresenceClearPresenceParameterSetBuilder builder) {
        this.sessionId = builder.sessionId;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static PresenceClearPresenceParameterSetBuilder newBuilder() {
        return new PresenceClearPresenceParameterSetBuilder();
    }
    /**
     * Fluent builder for the PresenceClearPresenceParameterSet
     */
    public static final class PresenceClearPresenceParameterSetBuilder {
        /**
         * The sessionId parameter value
         */
        @Nullable
        protected String sessionId;
        /**
         * Sets the SessionId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public PresenceClearPresenceParameterSetBuilder withSessionId(@Nullable final String val) {
            this.sessionId = val;
            return this;
        }
        /**
         * Instanciates a new PresenceClearPresenceParameterSetBuilder
         */
        @Nullable
        protected PresenceClearPresenceParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public PresenceClearPresenceParameterSet build() {
            return new PresenceClearPresenceParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.sessionId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("sessionId", sessionId));
        }
        return result;
    }
}
